//
//  LBInit.h
//  LBSDK
//
//  Created by xunjiangtao on 2018/6/6.
//  Copyright © 2018年 lebian. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef void(^QueryUpdateCallback)(int tag);

@interface LBInit : NSObject

@property (nonatomic, copy) QueryUpdateCallback cb;

/**
 实例
 
 @return 返回实例
 */
+ (instancetype)sharedInstance;

/**
 SDK启动入口
 
 @param launchOptions 传入APP启动参数
 @return 返回为YES或者NO。
 */
- (BOOL)LBSDKShouldInitWithLaunchOptions:(NSDictionary *)launchOptions;

#pragma mark - 一些可能需要用到的接口
/**
 热更检查更新接口，带回调；如果不需要回调，方法参数传nil
 
 回调参数tag:  -1  网络错误，请求失败
              1  有强更版本
              2  有非强更版本
              3  商店更新版本
              4  没有更新
 */
+ (void)queryUpdate:(QueryUpdateCallback)cb;
// 热更获取乐变当前版本号
+ (int)getCurrentLBVercode;
// 老用户下载完整资源接口（默认会弹框提示）
+ (void)downloadFullResource;
/**
 老用户下载完整资源接口，带参数
 不需要弹框提示，直接下载，参数设置为true
 需要弹框提示，参数设置为false
 */
+ (void)downloadFullResource:(bool)noPrompt;
// bwbx是否是小包
+ (bool)isSplitPackage;
// bwbx资源是否下载完成
+ (bool)isDownloadFinished;
// bwbx后台下载进度：(0-100)
+ (int)backgroundDownloadProgress;
// bwbx资源总大小（返回的是解压后的大小）  单位：byte
+ (long long)getTotalSize;
/**
 bwbx资源总大小（带参数）  单位：byte
 需要获取压缩大小，参数设置为true;
 需要获取解压大小，参数设置为false.
 */
+ (long long)getTotalSize:(bool)compress;
// bwbx已下载资源大小（返回的是解压后的大小）  单位：byte
+ (long long)getCurrentDlSize;
/**
 bwbx已下载资源大小（带参数）  单位：byte
 需要获取压缩大小，参数设置为true;
 需要获取解压大小，参数设置为false.
 */
+ (long long)getCurrentDlSize:(bool)compress;
// 手动开启后台边玩边下
+ (void)openDownload;
// 手动关闭后台边玩边下
+ (void)closeDownload;
/**
 后台下载状态
 返回值说明：下载中：    1001
         下载暂停：1002
         下载完成：1003
 */
+ (int)getDownloadStatus;
// 获取分包资源保存路径
+ (const char *)getResCachePath;
/**
指定单个资源的下载

返回值说明:   -1  该文件名不在分出资源列表中
            -2  安装包不是小包
            -3  文件正在下载中
            -4  网络错误，下载失败
            100 下载完成
             
*/
+ (int)singleFileDownload:(const char *)filename;
/**
 游戏启动时有拷贝/校验所有资源的操作
 
 开始拷贝/校验资源前调用，isExtracting设置为true.
 拷贝/校验完成后再次调用，isExtracting设置为false.
 */
+ (void)setResExtracting:(bool)isExtracting;
// 玩家已同意隐私协议
+ (void)setPrivacyChecked;

@end
