//
//  UniversalSDK.h
//  test_universal
//
//  Created by anon on 2021/3/27.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
NS_ASSUME_NONNULL_BEGIN
typedef void(^universalSDKCommonCallback) (NSString* info);
typedef void(^universalSDKUserLoginSuccessCallback) (NSString* userId ,NSString* token);
@interface UniversalSDK : NSObject

+(instancetype)getInstance;
-(void) universlSDKinit :(universalSDKCommonCallback) successCallback andFailCallback:(universalSDKCommonCallback) failCallback;
-(void) universlSDKLogin :(universalSDKUserLoginSuccessCallback) successCallback andLogout:(universalSDKCommonCallback) logoutCallback;
-(void)universalSDKVeirifyId:(universalSDKUserLoginSuccessCallback) callback;
-(void)universalSDKSubmitInfo:(NSString*)type andRoleId:(NSString*)roleId andRoleName:(NSString*)roleName andRoleLevel:(NSString*)roleLevel andServerId:(NSString*)serverId andServerName:(NSString*)serverName;
-(void)universalSDKPay:(NSString*)orderId  andPrice:(NSString*)price andTitle:(NSString*)title andProductId:(NSString*)productid andBody:(NSString*) body andExtend:(NSString*)extend andGameId:(NSString*)gameId andGameName:(NSString*)gameName andServerId:(NSString*)serverId andServerName:(NSString*)serverName andIsDoIt:(bool) isDoit andSuccessCallback:(universalSDKCommonCallback)successCallback andFailCallback:(universalSDKCommonCallback)failCallback;
-(void)universalSDKLogout;
-(void)showUniversalSDKFloatView;
-(void)RemoveUniversalSDKFloatView;
//设置聚合版本
-(void)setCoreVersion:(NSString*) version;
//微信handleopenurl
-(BOOL)universalSDKHandleOpenUrlWithUrl:(NSURL *)url andDelegate:(nullable id) delegate;

//设置游戏方向
-(BOOL)isFirstSetGameOrientation;
-(void)setUniveralSDKGameOrientation:( UIInterfaceOrientationMask) mask;
-(BOOL)universalSDKhandleUniversalLink:(NSUserActivity *)userActivity andDelegate:(nullable id )delegate;
-( UIInterfaceOrientationMask)getUniveralSDKGameOrientation;

@end

NS_ASSUME_NONNULL_END
