

#import <UIKit/UIKit.h>
#import <sys/utsname.h>
#import <AdSupport/ASIdentifierManager.h>
#import <Foundation/Foundation.h>
#import <CoreTelephony/CTTelephonyNetworkInfo.h>
#import <CoreTelephony/CTCarrier.h>
#import <Security/Security.h>
#import <CommonCrypto/CommonDigest.h>






#define OrzOSDKIsSandBox NO //NO：正式环境    YES：测试环境

/**
 1:简体
 2:繁体
 */
#define OrzOSDKLanguageType @"1"

#define OrzOSDKxKEYCHAINxIDFV @"OrzOSDK_KEYCHAIN_IDFV"
#define OrzOSDKxKEYCHAINxUUID @"OrzOSDK_KEYCHAIN_UUID"





typedef void (^OrzOSDKRequestCallback)(NSURLResponse* response, id data, NSError* connectionError);

typedef void (^OrzOSDKInitCallback)(NSDictionary* result);
typedef void (^OrzOSDKLoginCallback)(NSDictionary* result);
typedef void (^OrzOSDKLogoutCallback)(NSDictionary* result);
typedef void (^OrzOSDKCheckUpdateCallback)(NSDictionary* result);
typedef void (^OrzOSDKCreateOderCallback)(NSDictionary* result);
typedef void (^OrzOSDKXXXCloseCallback)(NSDictionary* result);
typedef void (^OrzOSDKShiMimgRenZhengCallback)(NSString* result);
typedef void (^OrzOSDKCommonCallback)(NSDictionary* result);
typedef void (^OrzOSDKYMCallBack)(NSString* ym, NSDictionary* result);
typedef void(^OrzOSDK_Success)(NSDictionary *);
typedef void(^OrzOSDK_Fail)(NSDictionary *);

typedef void(^OrzOSDK_AD_Success)(NSDictionary *);
typedef void(^OrzOSDK_AD_Fail)(NSDictionary *);

typedef void(^OrzOSDKOpenFromBox)(void);
typedef void(^OrzOSDKOpenFromOtherGame)(void);



#define OrzOSDK_SUBMIT_CHOOSE_SERVER      @"OrzOSDK_SUBMIT_CHOOSE_SERVER"
#define OrzOSDK_SUBMIT_CHOOSE_ROLE        @"OrzOSDK_SUBMIT_CHOOSE_ROLE"
#define OrzOSDK_SUBMIT_ROLE_CREATE        @"OrzOSDK_SUBMIT_ROLE_CREATE"
#define OrzOSDK_SUBMIT_ROLE_LEVELUP       @"OrzOSDK_SUBMIT_ROLE_LEVELUP"
#define OrzOSDK_SUBMIT_ROLE_ENTERSERVER   @"OrzOSDK_SUBMIT_ROLE_ENTERSERVER"
#define OrzOSDK_SUBMIT_ROLE_LOGOUT        @"OrzOSDK_SUBMIT_ROLE_LOGOUT"
#define OrzOSDK_SUBMIT_ROLE_ENTER_PARTY   @"OrzOSDK_SUBMIT_ROLE_ENTER_PARTY"
#define OrzOSDK_SUBMIT_PAY_SUCCESS        @"OrzOSDK_SUBMIT_PAY_SUCCESS"



#define OrzOSDK_ROLE_ID            @"OrzOSDK_ROLE_ID"
#define OrzOSDK_ROLE_LEVEL         @"OrzOSDK_ROLE_LEVEL"
#define OrzOSDK_ROLE_NAME          @"OrzOSDK_ROLE_NAME"
#define OrzOSDK_ROLE_CREATE_TIME   @"OrzOSDK_ROLE_CREATE_TIME"
#define OrzOSDK_SERVER_ID          @"OrzOSDK_SERVER_ID"
#define OrzOSDK_SERVER_NAME        @"OrzOSDK_SERVER_NAME"
#define OrzOSDK_ROLE_VIP           @"OrzOSDK_ROLE_VIP"//vip等级
#define OrzOSDK_ROLE_POWER         @"OrzOSDK_ROLE_POWER"//战力
#define OrzOSDK_ROLE_PARTY         @"OrzOSDK_ROLE_PARTY"//工会
#define OrzOSDK_ROLE_BALANCE       @"OrzOSDK_ROLE_BALANCE"//余额
#define OrzOSDK_ROLE_ZSLevel       @"OrzOSDK_ROLE_ZSLevel"//转生等级
#define OrzOSDK_ROLE_EXTENDS       @"OrzOSDK_ROLE_EXTENDS"//扩展信息


#define OrzOSDK_IOS_PRODUCT_NAME   @"OrzOSDK_IOS_PRODUCT_NAME"
#define OrzOSDK_IOS_PRODUCT_ID     @"OrzOSDK_IOS_PRODUCT_ID"
#define OrzOSDK_IOS_CP_ORDERID     @"OrzOSDK_IOS_CP_ORDERID"
#define OrzOSDK_IOS_PRODUCT_DESC   @"OrzOSDK_IOS_PRODUCT_DESC"
#define OrzOSDK_IOS_PRODUCT_PRICE  @"OrzOSDK_IOS_PRODUCT_PRICE"
#define OrzOSDK_IOS_GOODS_NUM      @"OrzOSDK_IOS_GOODS_NUM"
#define OrzOSDK_IOS_ORDERID        @"OrzOSDK_IOS_ORDERID"
#define OrzOSDK_IOS_EXTRA          @"OrzOSDK_IOS_EXTRA"
#define OrzOSDK_IOS_ROLE_ID        @"OrzOSDK_IOS_ROLE_ID"
#define OrzOSDK_IOS_ROLE_NAME      @"OrzOSDK_IOS_ROLE_NAME"
#define OrzOSDK_IOS_ROLE_LEVEL     @"OrzOSDK_IOS_ROLE_LEVEL"
#define OrzOSDK_IOS_SERVER_ID      @"OrzOSDK_IOS_SERVER_ID"
#define OrzOSDK_IOS_SERVER_NAME    @"OrzOSDK_IOS_SERVER_NAME"







@interface OrzOSDKUtils : NSObject

+(OrzOSDKUtils*)getSharedInstance;


-(void) showOrzOSDKToastMsg:(NSString *)text view:(UIView *)view;
-(void) showOrzOSDKNetAccessToastMsg:(NSString *)text view:(UIView *)view;
-(void) hideOrzOSDKNetAccessToastMsg;

-(void)OrzOSDKSetPackageIdUtils:(NSString *)packegeId;
-(void)OrzOSDKSetNewParamsUtils:(NSString *)packegeId appid:(NSString *)appid appsecret:(NSString *)appsecret;

-(NSString *)getOrzOSDKNetIsp;//获取运营商信息
-(NSString *)getOrzOSDKNetworktype;//获取网络类型
-(NSString *)getOrzOSDKSystemVersion;//获取手机系统版本
-(NSString *)getOrzOSDKIdfa;//获取手机idfa
-(NSString *)getOrzOSDKIdfv;//获取手机idfv
-(NSString *)getOrzOSDKUUID;//获取手机getOrzOSDKUUID
-(NSString *)getOrzOSDKMac;//获取手机getOrzOSDKMac
-(NSString *)getOrzOSDKPhoneUserName;//获取手机别名
-(NSString *)getOrzOSDKDeviceName;//获取设备名称
-(NSString *)getOrzOSDKDeviceModel;//获取手机型号
-(NSString *)getOrzOSDKLocalPhoneModel;//获取地方型号（国际化区域名称）

-(NSString *)getOrzOSDKBundleId;
-(NSString *)getOrzOSDKAppName;
-(NSString *)getOrzOSDKAppVersion;
-(NSString *)getOrzOSDKAppBuildVersion;
-(NSString *)getOrzOSDKVersion;
-(NSString *)getOrzOSDKChannelSdkVersion;

-(NSString *)getOrzOSDKInfoPlist_PackageId;
-(Boolean)getOrzOSDKInfoPlist_Landscape;
-(NSString *)getOrzOSDKSecret;


-(void)setOrzOSDKUserInfo:(NSString*) username userid:(NSString*) userid password:(NSString*) password token:(NSString*) token;
-(NSString *)getOrzOSDKUserId;
-(NSString *)getChannelUserId;

-(NSString *)getOrzOSDKTimestamp;
-(NSString *)OrzOSDKMd5:(NSString *)str;

-(NSString *)getOrzOSDKCpChannelId;

-(void) initOrzOSDKRealYM:(OrzOSDKYMCallBack)cb;
-(void)initOrzOSDKIDFA:(NSString *)sys_version cb:(OrzOSDKCommonCallback)idfaCb;

-(NSString *)getOrzOSDKEnableUrl;
-(void)postOrzOSDKActiveData;
-(void)postOrzOSDKGameData:(NSString *)dataPoint data:(NSDictionary *)data;
-(void)postOrzOSDKHFiveData:(NSString *)clickId beginTime:(NSString *)beginTime jumpTime:(NSString *)jumpTime endTime:(NSString *)endTime;
-(void)requestOrzOSDKNotice:(OrzOSDKRequestCallback)result;
-(void)requestOrzOSDKServerStatus:(OrzOSDKInitCallback)result;
-(void)getOrzOSDKLoginInfo:(NSDictionary *)dic result:(OrzOSDKLoginCallback)result;
-(void)doOrzOSDKLogout:(OrzOSDKLogoutCallback)result;
-(void)doOrzOSDKCheckUpdate:(OrzOSDKCheckUpdateCallback)result;
-(void)doOrzOSDKCreateOder:(NSDictionary *)param buildOrzOSDKodcb:(OrzOSDKCreateOderCallback)buildOrzOSDKodcb;
-(void)doOrzOSDKCheckFunctionSuccess:(NSString *)func result:(OrzOSDKCommonCallback)result;
-(void)doOrzOSDKGetReviewStatus:(NSString *)type loginNum:(NSString *)loginNum activeTime:(NSString *)activeTime result:(OrzOSDKCommonCallback)result;
-(void)sendOrzOSDKHeartData;
-(void)doOrzOSDKPostAction:(NSDictionary *)httpParams toOrzOSDKServer:(NSString *)requestPath responseHandler:(OrzOSDKRequestCallback)handler showProgess:(Boolean)showprogress;

-(void)doInsideOrzOSDKLoginUtils:(OrzOSDKLoginCallback)loginCallback;


- (void)applicationDidBecomeActive:(UIApplication *)application;
- (void)applicationWillResignActive:(UIApplication *)application;

-(BOOL)checkOrzOSDKIsNull:(NSString *)str;

@end


