#import <UIKit/UIKit.h>

@interface OrzOSDKData : NSObject

/**
 初始化接口
 @param appId 参数appId
 @param appKey 参数appKey
 */
+(void)initOrzOSDKData:(NSString *)appId appKey:(NSString *)appKey mode:(NSString *)mode;


/**
 设置平台账号Id
 @param accountId 传入平台账号Id，例如sdk登录后的accountId
 */
+(void)setOrzOSDKDataAccountId:(NSString *)accountId;


/**
 设置roleId，一个平台账号ID下可能有多个角色，此接口可以设置角色ID
 @param roleId 传入标识用户的最小单位，例如角色id
 */
+(void)setOrzOSDKDataRoleId:(NSString *)roleId;


/**
 事件上报接口
 @param eventName 事件名称
 @param eventParams 事件属性
 */
+(void)eventOrzOSDKData:(NSString *)eventName eventParams:(NSDictionary *)eventParams;


/**
 用户属性设置接口
 @param userParams 用户属性
 */
+(void)setOrzOSDKDataUserProperty:(NSDictionary *)userParams;

/**
 公共属性设置接口
 @param superParams 公共属性
 */
+(void)setOrzOSDKDataSuperProperty:(NSDictionary *)superParams;
@end
