

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "OrzOSDKUtils.h"



@protocol OrzOSDKDelegate <NSObject>

-(void)initOrzOSDKSuccess:(NSDictionary *)result;

-(void)initOrzOSDKFail:(NSDictionary *)result;

-(void)loginOrzOSDKSuccess:(NSDictionary *)result;

-(void)loginOrzOSDKFail:(NSDictionary *)result;

-(void)logoutOrzOSDKSuccess:(NSDictionary *)result;

-(void)logoutOrzOSDKFail:(NSDictionary *)result;

-(void)RegchargOrzOSDKSuccess:(NSDictionary *)result;

-(void)RegchargOrzOSDKFail:(NSDictionary *)result;

-(void)openOrzOSDKUserCenter;
-(void)closeOrzOSDKUserCenter;

@end

@protocol OrzOSDKRewardAdDelegate<NSObject>

- (void)OrzOSDKRewardWillLoad;/** 即将加载激励广告 */

- (void)OrzOSDKRewardAdDidLoad;/** 激励广告加载成功 */

- (void)OrzOSDKRewardAdDidLoadFail:(NSString *)errMsg;/** 激励广告加载失败 */

- (void)OrzOSDKRewardAdWillShow;/** 即将展示激励广告 */

- (void)OrzOSDKRewardAdDidShow;/** 开始展示激励广告 */

- (void)OrzOSDKRewardAdshowFail:(NSString *)failmsg;/** 展示激励广告失败 */

- (void)OrzOSDKRewardAdStartPlay;/** 开始播放视频激励广告 */

- (void)OrzOSDKRewardAdDidCilck;/** 用户点击激励广告 */

- (void)OrzOSDKRewardAdWillLeaveApp;/** 因用户点击广告即将离开应用 */

- (void)OrzOSDKRewardAdSkip;/** 用户点击跳过广告 */

- (void)OrzOSDKRewardAdDidEndPlay;/** 视屏激励广告播放完毕 */

- (void)OrzOSDKRewardADWillClose;/** 即将关闭激励广告 */

- (void)OrzOSDKRewardAdDidClose;/** 关闭激励广告 */

- (void)OrzOSDKRewardAdDidRewardUserWithReward:(NSDictionary *)reward;/** 满足激励发放条件发放奖励 */

- (void)OrzOSDKRewardAdDontReward:(NSString *)errorMsg;/** 不满足激励条件无法发放激励 */

@end


@interface OrzOSDK : NSObject

@property (strong, nonatomic) id<OrzOSDKDelegate> OrzOSDKDelegate;

@property (strong, nonatomic) id<OrzOSDKRewardAdDelegate> rewardAdOrzOSDKDelegate;

@property (nonatomic) BOOL OrzOSDKnetWorkIsOK;




+(OrzOSDK*)getSharedInstance;


-(void)OrzOSDKSetPackageId:(NSString *)packegeId;

-(void)OrzOSDKSetNewParams:(NSString *)packegeId appid:(NSString *)appid appsecret:(NSString *)appsecret;

-(void)initOrzOSDK;

-(void)startOrzOSDKLogin;

-(void)doInsideOrzOSDKLogin:(OrzOSDKLoginCallback)loginCallback;

-(void)startOrzOSDKSwitchAccount;

-(void)startOrzOSDKLogout;

-(void)showOrzOSDKGameCenter;

-(void)showOrzOSDKFloatView;

-(void)hideOrzOSDKFloatView;

-(void)startOrzOSDKRegcharg:(NSDictionary *)params;

-(void)sendOrzOSDKData:(NSString *)dataPoint data:(NSDictionary *)data;

-(void)sendOrzOSDKHFiveData:(NSString *)clickId beginTime:(NSString *)beginTime jumpTime:(NSString *)jumpTime endTime:(NSString *)endTime;

-(void)getOrzOSDKActiveConfiguration:(OrzOSDKCommonCallback)result;

-(void)showOrzOSDKAgeFitView;//显示适龄
-(void)hideOrzOSDKAgeFitView;//隐藏适龄

-(void)setOrzOSDKOpenFromBoxListener:(OrzOSDKOpenFromBox)cbOrzOSDK;

-(void)setOrzOSDKFromOpenOtherGameListener:(OrzOSDKOpenFromOtherGame)cbOrzOSDK;

-(void)doOrzOSDKRewardAdInit;

-(void)showOrzOSDKRewardAdVideo:(NSString *)cpOid zoneId:(NSString *)zoneId extInfo:(NSString *)extInfo rewardCount:(NSString *)rewardCount rewardId:(NSString *)rewardId rewardName:(NSString *)rewardName roleId:(NSString *)roleId roleName:(NSString *)roleName serverId:(NSString *)serverId serverName:(NSString *)serverName;

-(BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions;
- (void)applicationWillResignActive:(UIApplication *)application;
- (void)applicationDidEnterBackground:(UIApplication *)application;
- (void)applicationWillEnterForeground:(UIApplication *)application;
- (void)applicationDidBecomeActive:(UIApplication *)application;
- (void)applicationWillTerminate:(UIApplication *)application;

-(BOOL)application:(UIApplication *)application handleOpenURL:(NSURL *)url;
-(BOOL)application:(UIApplication *)application openURL:(NSURL *)url options:(NSDictionary<UIApplicationOpenURLOptionsKey,id> *)options;
-(BOOL)application:(UIApplication *)application openURL:(NSURL *)url sourceApplication:(NSString *)sourceApplication annotation:(id)annotation;

-(UIInterfaceOrientationMask)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(nullable UIWindow *)window;

-(BOOL)application:(UIApplication *)application continueUserActivity:(NSUserActivity *)userActivity restorationHandler:(void(^)(NSArray * __nullable restorableObjects))restorationHandler;


- (void)application:(UIApplication *)application didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken;
- (void)application:(UIApplication *)application didReceiveRemoteNotification:(NSDictionary *)userInfo;
- (void)application:(UIApplication *)application didReceiveRemoteNotification:(NSDictionary *)userInfo fetchCompletionHandler:(void (^)(UIBackgroundFetchResult))completionHandler;

@end



