

#import "ViewController.h"
#import "OrzOSDK.h"
#import "OrzOSDKUtils.h"
#import<SystemConfiguration/CaptiveNetwork.h>
#import <AppTrackingTransparency/AppTrackingTransparency.h>
@interface ViewController()<OrzOSDKDelegate>



@end

@implementation ViewController

- (BOOL)shouldAutorotate {
    return YES;
}
//支持的方向 因为界面A我们只需要支持竖屏
//- (UIInterfaceOrientationMask)supportedInterfaceOrientations {
//    return UIInterfaceOrientationMaskLandscape;
//}

-(NSString *)ssid{
    NSString *ssid = @"未连接";
    CFArrayRef myArray = CNCopySupportedInterfaces();
    if (myArray != nil) {
        CFDictionaryRef myDict = CNCopyCurrentNetworkInfo(CFArrayGetValueAtIndex(myArray, 0));
        if (myDict != nil) {
            NSDictionary *dict = (NSDictionary*)CFBridgingRelease(myDict);
            ssid = [dict valueForKey:@"SSID"];
        }
    }
    return ssid;
    
}

-(void)viewWillAppear:(BOOL)animated
{
    self.navigationController.navigationBarHidden = NO;
    [self.navigationController setNavigationBarHidden:NO animated:NO];
    self.navigationController.navigationBar.translucent = NO;
    [UIApplication sharedApplication].statusBarHidden = NO;
}

- (void)viewDidAppear:(BOOL)animated{
    
    NSLog(@"viewDidAppear-------");
    [self action_init];
}

- (void)viewDidLoad {
    NSLog(@"viewDidLoad-------");
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    self.view.backgroundColor = [UIColor grayColor];
    
    self.bInitSuccess = false;
    
    NSLog(@"wifi ssid = %@", [self ssid]);
    
    
    UIButton *btn_init = [UIButton buttonWithType:0];
    btn_init.frame = CGRectMake(20, 20, 100, 30);
    btn_init.backgroundColor = [UIColor blueColor];
    [btn_init setTitle:@"初始化" forState:UIControlStateNormal];
    [btn_init addTarget:self action:@selector(action_init) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn_init];
    
    
    UIButton *btn_login = [UIButton buttonWithType:0];
    btn_login.frame = CGRectMake(20, 70, 100, 30);
    btn_login.backgroundColor = [UIColor blueColor];
    [btn_login setTitle:@"登录" forState:UIControlStateNormal];
    [btn_login addTarget:self action:@selector(action_login) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn_login];
    
    
    UIButton *btn_logout = [UIButton buttonWithType:0];
    btn_logout.frame = CGRectMake(20, 120, 100, 30);
    btn_logout.backgroundColor = [UIColor blueColor];
    [btn_logout setTitle:@"登出" forState:UIControlStateNormal];
    [btn_logout addTarget:self action:@selector(action_logout) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn_logout];
    
    
    UIButton *btn_showfloat = [UIButton buttonWithType:0];
    btn_showfloat.frame = CGRectMake(150, 20, 100, 30);
    btn_showfloat.backgroundColor = [UIColor blueColor];
    [btn_showfloat setTitle:@"显示浮标" forState:UIControlStateNormal];
    [btn_showfloat addTarget:self action:@selector(action_showfloat) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn_showfloat];
    
    
    UIButton *btn_hidefloat = [UIButton buttonWithType:0];
    btn_hidefloat.frame = CGRectMake(150, 70, 100, 30);
    btn_hidefloat.backgroundColor = [UIColor blueColor];
    [btn_hidefloat setTitle:@"隐藏浮标" forState:UIControlStateNormal];
    [btn_hidefloat addTarget:self action:@selector(action_hidefloat) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn_hidefloat];
    
    UIButton *btn_pay = [UIButton buttonWithType:0];
    btn_pay.frame = CGRectMake(150, 120, 100, 30);
    btn_pay.backgroundColor = [UIColor blueColor];
    [btn_pay setTitle:@"6元支付" forState:UIControlStateNormal];
    [btn_pay addTarget:self action:@selector(action_pay) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn_pay];
    
    
    UIButton *btn_createrole = [UIButton buttonWithType:0];
    btn_createrole.frame = CGRectMake(20, 170, 100, 30);
    btn_createrole.backgroundColor = [UIColor blueColor];
    [btn_createrole setTitle:@"创建角色" forState:UIControlStateNormal];
    [btn_createrole addTarget:self action:@selector(action_createrole) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn_createrole];
    
    UIButton *btn_rolelogin = [UIButton buttonWithType:0];
    btn_rolelogin.frame = CGRectMake(150, 170, 100, 30);
    btn_rolelogin.backgroundColor = [UIColor blueColor];
    [btn_rolelogin setTitle:@"角色登陆" forState:UIControlStateNormal];
    [btn_rolelogin addTarget:self action:@selector(action_rolelogin) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn_rolelogin];
    
    UIButton *btn_levelup = [UIButton buttonWithType:0];
    btn_levelup.frame = CGRectMake(20, 220, 100, 30);
    btn_levelup.backgroundColor = [UIColor blueColor];
    [btn_levelup setTitle:@"角色升级" forState:UIControlStateNormal];
    [btn_levelup addTarget:self action:@selector(action_levelup) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn_levelup];
    
    
    UIButton *btn_seclogin = [UIButton buttonWithType:0];
    btn_seclogin.frame = CGRectMake(150, 220, 100, 30);
    btn_seclogin.backgroundColor = [UIColor blueColor];
    [btn_seclogin setTitle:@"二次登录" forState:UIControlStateNormal];
    [btn_seclogin addTarget:self action:@selector(action_seclogin) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn_seclogin];
    
    
    
    UIButton *btn_pay30 = [UIButton buttonWithType:0];
    btn_pay30.frame = CGRectMake(20, 270, 100, 30);
    btn_pay30.backgroundColor = [UIColor blueColor];
    [btn_pay30 setTitle:@"30支付" forState:UIControlStateNormal];
    [btn_pay30 addTarget:self action:@selector(action_pay30) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn_pay30];
    
    
    UIButton *btn_pay68 = [UIButton buttonWithType:0];
    btn_pay68.frame = CGRectMake(150, 270, 100, 30);
    btn_pay68.backgroundColor = [UIColor blueColor];
    [btn_pay68 setTitle:@"68支付" forState:UIControlStateNormal];
    [btn_pay68 addTarget:self action:@selector(action_pay68) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn_pay68];
    
    UIButton *btn_pay168 = [UIButton buttonWithType:0];
    btn_pay168.frame = CGRectMake(20, 320, 100, 30);
    btn_pay168.backgroundColor = [UIColor blueColor];
    [btn_pay168 setTitle:@"168支付" forState:UIControlStateNormal];
    [btn_pay168 addTarget:self action:@selector(action_pay168) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn_pay168];
    

//    if ([[ASIdentifierManager sharedManager] isAdvertisingTrackingEnabled]) {
//        NSLog(@"isAdvertisingTrackingEnabled");
//    }else{
//        NSLog(@"isAdvertisingTracking not Enabled");
//    }
//    
//    if([ATTrackingManager trackingAuthorizationStatus] == ATTrackingManagerAuthorizationStatusDenied){
//        NSLog(@"ATTrackingManagerAuthorizationStatusDenied 1");
//    }else if([ATTrackingManager trackingAuthorizationStatus] == ATTrackingManagerAuthorizationStatusAuthorized){
//        NSLog(@"ATTrackingManagerAuthorizationStatusAuthorized 2");
//    }else if([ATTrackingManager trackingAuthorizationStatus] == ATTrackingManagerAuthorizationStatusRestricted){
//        NSLog(@"ATTrackingManagerAuthorizationStatusRestricted 3");
//    }else if([ATTrackingManager trackingAuthorizationStatus] == ATTrackingManagerAuthorizationStatusNotDetermined){
//        NSLog(@"ATTrackingManagerAuthorizationStatusNotDetermined 4");
//    }
//    
//    [ATTrackingManager requestTrackingAuthorizationWithCompletionHandler:^(ATTrackingManagerAuthorizationStatus status) {
//        // 获取到权限后，依然使用老方法获取idfa
//        if(status == ATTrackingManagerAuthorizationStatusDenied){
//            NSLog(@"1 ATTrackingManagerAuthorizationStatusDenied 1");
//        }else if(status == ATTrackingManagerAuthorizationStatusAuthorized){
//            NSLog(@"1 ATTrackingManagerAuthorizationStatusAuthorized 2");
//        }else if(status == ATTrackingManagerAuthorizationStatusRestricted){
//            NSLog(@"1 ATTrackingManagerAuthorizationStatusRestricted 3");
//        }else if(status == ATTrackingManagerAuthorizationStatusNotDetermined){
//            NSLog(@"1 ATTrackingManagerAuthorizationStatusNotDetermined 4");
//        }
//    }];

}



-(void)action_init{
    [OrzOSDK getSharedInstance].OrzOSDKDelegate = self;
    [[OrzOSDK getSharedInstance] initOrzOSDK];

    
    
}


-(void)action_login{

    [[OrzOSDK getSharedInstance] startOrzOSDKLogin];

}

-(void)action_seclogin{
    [[OrzOSDK getSharedInstance] OrzOSDKSetPackageId:@"2398"];
    [[OrzOSDK getSharedInstance] doInsideOrzOSDKLogin:^(NSDictionary *result) {
        NSLog(@"second login : %@", result);
    }];
}

-(void)action_logout{
    [[OrzOSDK getSharedInstance] startOrzOSDKLogout];
}

-(void)action_showfloat{
    [[OrzOSDK getSharedInstance] showOrzOSDKFloatView];
}

-(void)action_hidefloat{
    [[OrzOSDK getSharedInstance] hideOrzOSDKFloatView];
    
    

}

-(void)action_pay{
    
    
    NSDate* dat = [NSDate dateWithTimeIntervalSinceNow:0];
    NSTimeInterval a=[dat timeIntervalSince1970]*1000;
    NSString* orderId = [NSString stringWithFormat:@"demo%f", a];
    
    NSMutableDictionary * data = [NSMutableDictionary dictionary];
    [data setValue:@"60yuanbao" forKey:OrzOSDK_IOS_PRODUCT_NAME];//必传，商品名称
    [data setValue:@"com.test.6" forKey:OrzOSDK_IOS_PRODUCT_ID];//必传，商品id，由运营提供
    [data setValue:orderId forKey:OrzOSDK_IOS_CP_ORDERID];//必传，CP订单号，若无，则传时间戳
    [data setValue:@"OrzOSDK_IOS_PRODUCT_DESC" forKey:OrzOSDK_IOS_PRODUCT_DESC];//必传，若无，则传商品名称
    [data setValue:@"6" forKey:OrzOSDK_IOS_PRODUCT_PRICE];//必传，商品价格，单位：元,不带小数点
    [data setValue:@"1" forKey:OrzOSDK_IOS_GOODS_NUM];//必传，商品购买数量；一般传1
    [data setValue:@"OrzOSDK_IOS_EXTRA" forKey:OrzOSDK_IOS_EXTRA];//必传，扩展信息，若无，则传空
    [data setValue:@"OrzOSDK_IOS_ROLE_ID" forKey:OrzOSDK_IOS_ROLE_ID];//必传，角色id
    [data setValue:@"OrzOSDK_IOS_ROLE_NAME" forKey:OrzOSDK_IOS_ROLE_NAME];//必传，角色名称
    [data setValue:@"OrzOSDK_IOS_ROLE_LEVEL" forKey:OrzOSDK_IOS_ROLE_LEVEL];//必传，角色等级
    [data setValue:@"OrzOSDK_IOS_SERVER_ID" forKey:OrzOSDK_IOS_SERVER_ID];//必传，服务器id
    [data setValue:@"OrzOSDK_IOS_SERVER_NAME" forKey:OrzOSDK_IOS_SERVER_NAME];//必传，服务器名称
    [[OrzOSDK getSharedInstance] startOrzOSDKRegcharg:data];
    
}

-(void)action_pay30{
    
    
    NSDate* dat = [NSDate dateWithTimeIntervalSinceNow:0];
    NSTimeInterval a=[dat timeIntervalSince1970]*1000;
    NSString* orderId = [NSString stringWithFormat:@"demo%f", a];
    
    NSMutableDictionary * data = [NSMutableDictionary dictionary];
    [data setValue:@"300yuanbao" forKey:OrzOSDK_IOS_PRODUCT_NAME];//必传，商品名称
    [data setValue:@"com.ktgame.m3.product30" forKey:OrzOSDK_IOS_PRODUCT_ID];//必传，商品id，由运营提供
    [data setValue:orderId forKey:OrzOSDK_IOS_CP_ORDERID];//必传，CP订单号，若无，则传时间戳
    [data setValue:@"OrzOSDK_IOS_PRODUCT_DESC" forKey:OrzOSDK_IOS_PRODUCT_DESC];//必传，若无，则传商品名称
    [data setValue:@"30" forKey:OrzOSDK_IOS_PRODUCT_PRICE];//必传，商品价格，单位：元,不带小数点
    [data setValue:@"1" forKey:OrzOSDK_IOS_GOODS_NUM];//必传，商品购买数量；一般传1
    [data setValue:@"OrzOSDK_IOS_EXTRA" forKey:OrzOSDK_IOS_EXTRA];//必传，扩展信息
    [data setValue:@"OrzOSDK_IOS_ROLE_ID" forKey:OrzOSDK_IOS_ROLE_ID];//必传，角色id
    [data setValue:@"OrzOSDK_IOS_ROLE_NAME" forKey:OrzOSDK_IOS_ROLE_NAME];//必传，角色名称
    [data setValue:@"OrzOSDK_IOS_ROLE_LEVEL" forKey:OrzOSDK_IOS_ROLE_LEVEL];//必传，角色等级
    [data setValue:@"OrzOSDK_IOS_SERVER_ID" forKey:OrzOSDK_IOS_SERVER_ID];//必传，服务器id
    [data setValue:@"OrzOSDK_IOS_SERVER_NAME" forKey:OrzOSDK_IOS_SERVER_NAME];//必传，服务器名称
    [[OrzOSDK getSharedInstance] startOrzOSDKRegcharg:data];
    
}

-(void)action_pay68{
    
    
    NSDate* dat = [NSDate dateWithTimeIntervalSinceNow:0];
    NSTimeInterval a=[dat timeIntervalSince1970]*1000;
    NSString* orderId = [NSString stringWithFormat:@"demo%f", a];
    
    NSMutableDictionary * data = [NSMutableDictionary dictionary];
    [data setValue:@"680yuanbao" forKey:OrzOSDK_IOS_PRODUCT_NAME];//必传，商品名称
    [data setValue:@"com.ktgame.m3.product68" forKey:OrzOSDK_IOS_PRODUCT_ID];//必传，商品id，由运营提供
    [data setValue:orderId forKey:OrzOSDK_IOS_CP_ORDERID];//必传，CP订单号，若无，则传时间戳
    [data setValue:@"OrzOSDK_IOS_PRODUCT_DESC" forKey:OrzOSDK_IOS_PRODUCT_DESC];//必传，若无，则传商品名称
    [data setValue:@"68" forKey:OrzOSDK_IOS_PRODUCT_PRICE];//必传，商品价格，单位：元,不带小数点
    [data setValue:@"1" forKey:OrzOSDK_IOS_GOODS_NUM];//必传，商品购买数量；一般传1
    [data setValue:@"OrzOSDK_IOS_EXTRA" forKey:OrzOSDK_IOS_EXTRA];//必传，扩展信息
    [data setValue:@"OrzOSDK_IOS_ROLE_ID" forKey:OrzOSDK_IOS_ROLE_ID];//必传，角色id
    [data setValue:@"OrzOSDK_IOS_ROLE_NAME" forKey:OrzOSDK_IOS_ROLE_NAME];//必传，角色名称
    [data setValue:@"OrzOSDK_IOS_ROLE_LEVEL" forKey:OrzOSDK_IOS_ROLE_LEVEL];//必传，角色等级
    [data setValue:@"OrzOSDK_IOS_SERVER_ID" forKey:OrzOSDK_IOS_SERVER_ID];//必传，服务器id
    [data setValue:@"OrzOSDK_IOS_SERVER_NAME" forKey:OrzOSDK_IOS_SERVER_NAME];//必传，服务器名称
    [[OrzOSDK getSharedInstance] startOrzOSDKRegcharg:data];
    
}

-(void)action_pay168{
    
    
    NSDate* dat = [NSDate dateWithTimeIntervalSinceNow:0];
    NSTimeInterval a=[dat timeIntervalSince1970]*1000;
    NSString* orderId = [NSString stringWithFormat:@"demo%f", a];
    
    NSMutableDictionary * data = [NSMutableDictionary dictionary];
    [data setValue:@"1680yuanbao" forKey:OrzOSDK_IOS_PRODUCT_NAME];//必传，商品名称
    [data setValue:@"20203004" forKey:OrzOSDK_IOS_PRODUCT_ID];//必传，商品id，由运营提供
    [data setValue:orderId forKey:OrzOSDK_IOS_CP_ORDERID];//必传，CP订单号，若无，则传时间戳
    [data setValue:@"OrzOSDK_IOS_PRODUCT_DESC" forKey:OrzOSDK_IOS_PRODUCT_DESC];//必传，若无，则传商品名称
    [data setValue:@"168" forKey:OrzOSDK_IOS_PRODUCT_PRICE];//必传，商品价格，单位：元,不带小数点
    [data setValue:@"1" forKey:OrzOSDK_IOS_GOODS_NUM];//必传，商品购买数量；一般传1
    [data setValue:@"OrzOSDK_IOS_EXTRA" forKey:OrzOSDK_IOS_EXTRA];//必传，扩展信息
    [data setValue:@"OrzOSDK_IOS_ROLE_ID" forKey:OrzOSDK_IOS_ROLE_ID];//必传，角色id
    [data setValue:@"OrzOSDK_IOS_ROLE_NAME" forKey:OrzOSDK_IOS_ROLE_NAME];//必传，角色名称
    [data setValue:@"OrzOSDK_IOS_ROLE_LEVEL" forKey:OrzOSDK_IOS_ROLE_LEVEL];//必传，角色等级
    [data setValue:@"OrzOSDK_IOS_SERVER_ID" forKey:OrzOSDK_IOS_SERVER_ID];//必传，服务器id
    [data setValue:@"OrzOSDK_IOS_SERVER_NAME" forKey:OrzOSDK_IOS_SERVER_NAME];//必传，服务器名称
    [[OrzOSDK getSharedInstance] startOrzOSDKRegcharg:data];
    
}

-(void)action_createrole{
    NSDate* data1= [NSDate dateWithTimeIntervalSinceNow:0];
    NSTimeInterval interval=[data1 timeIntervalSince1970];
    NSString *timeString = [NSString stringWithFormat:@"%0.f", interval];//转为字符型
    
    NSMutableDictionary * data = [NSMutableDictionary dictionary];
    [data setValue:@"1" forKey:OrzOSDK_ROLE_ID];//必传，角色ID
    [data setValue:@"1" forKey:OrzOSDK_ROLE_LEVEL];//必传，角色等级
    [data setValue:@"roleName" forKey:OrzOSDK_ROLE_NAME];//必传，角色名称
    [data setValue:timeString forKey:OrzOSDK_ROLE_CREATE_TIME];//必传，角色创建时间，时间戳，精确到秒
    [data setValue:@"1" forKey:OrzOSDK_SERVER_ID];//必传，服务器id
    [data setValue:@"serverName" forKey:OrzOSDK_SERVER_NAME];//必传，服务器名称
    [[OrzOSDK getSharedInstance] sendOrzOSDKData:OrzOSDK_SUBMIT_ROLE_CREATE data:data];
}

-(void)action_rolelogin{
    NSDate* data1= [NSDate dateWithTimeIntervalSinceNow:0];
    NSTimeInterval interval=[data1 timeIntervalSince1970];
    NSString *timeString = [NSString stringWithFormat:@"%0.f", interval];//转为字符型
    
    NSMutableDictionary * data = [NSMutableDictionary dictionary];
    [data setValue:@"1" forKey:OrzOSDK_ROLE_ID];//必传，角色ID
    [data setValue:@"1" forKey:OrzOSDK_ROLE_LEVEL];//必传，角色等级
    [data setValue:@"roleName" forKey:OrzOSDK_ROLE_NAME];//必传，角色名称
    [data setValue:timeString forKey:OrzOSDK_ROLE_CREATE_TIME];//必传，角色创建时间，时间戳，精确到秒
    [data setValue:@"1" forKey:OrzOSDK_SERVER_ID];//必传，服务器id
    [data setValue:@"serverName" forKey:OrzOSDK_SERVER_NAME];//必传，服务器名称
    [[OrzOSDK getSharedInstance] sendOrzOSDKData:OrzOSDK_SUBMIT_ROLE_ENTERSERVER data:data];
}

-(void)action_levelup{
    NSDate* data1= [NSDate dateWithTimeIntervalSinceNow:0];
    NSTimeInterval interval=[data1 timeIntervalSince1970];
    NSString *timeString = [NSString stringWithFormat:@"%0.f", interval];//转为字符型
    
    NSMutableDictionary * data = [NSMutableDictionary dictionary];
    [data setValue:@"1" forKey:OrzOSDK_ROLE_ID];//必传，角色ID
    [data setValue:@"1" forKey:OrzOSDK_ROLE_LEVEL];//必传，角色等级
    [data setValue:@"roleName" forKey:OrzOSDK_ROLE_NAME];//必传，角色名称
    [data setValue:timeString forKey:OrzOSDK_ROLE_CREATE_TIME];//必传，角色创建时间，时间戳，精确到秒
    [data setValue:@"1" forKey:OrzOSDK_SERVER_ID];//必传，服务器id
    [data setValue:@"serverName" forKey:OrzOSDK_SERVER_NAME];//必传，服务器名称
    [[OrzOSDK getSharedInstance] sendOrzOSDKData:OrzOSDK_SUBMIT_ROLE_LEVELUP data:data];
}

//---------------OrzOSDKDelegate---------------
-(void)initOrzOSDKSuccess:(NSDictionary *)result{
    NSLog(@"initSuccess : %@", result);
    /*
     initSuccess : {
     "channel_id" = 111;
     code = 0;
     msg = "init success!";
     serverid = "xx";
     }*/
//    [[OrzOSDK getSharedInstance] startOrzOSDKLogin];
    [self showDialog:[NSString stringWithFormat:@"%@", result] title:@"初始化成功"];

}

-(void)initOrzOSDKFail:(NSDictionary *)result{
    NSLog(@"initFail : %@", result);
    
    [self showDialog:@"初始化失败" title:@"提示"];
    UIAlertController *alertVc = [UIAlertController alertControllerWithTitle:@"初始化失败" message:result[@"msg"] preferredStyle:UIAlertControllerStyleActionSheet];
    //默认只有标题 没有操作的按钮:添加操作的按钮 UIAlertAction

    UIAlertAction *cancelBtn = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        NSLog(@"取消");
    }];
    //添加确定
    UIAlertAction *sureBtn = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDestructive handler:^(UIAlertAction * _Nonnull   action) {
        NSLog(@"确定");
        [[OrzOSDK getSharedInstance] initOrzOSDK];
    }];
    //设置`确定`按钮的颜色
    [sureBtn setValue:[UIColor redColor] forKey:@"titleTextColor"];
    //将action添加到控制器
    [alertVc addAction:cancelBtn];
    [alertVc addAction :sureBtn];
    //展示
    [self presentViewController:alertVc animated:YES completion:nil];
    
//    [[OrzOSDK getSharedInstance] initOrzOSDK];

}

-(void)loginOrzOSDKSuccess:(NSDictionary *)result{
    NSLog(@"loginSuccess : %@", result);
    
    
    /*
     loginSuccess : {
        "channel_id" = 18;
        "channel_name" = 39sdk;
        "channel_userid" = 19474182;
        code = 0;
        msg = "login success";
        "sdk_nickname" = "sjhy380476210621.39";
        "sdk_token" = f429ea9560d20d54f6eed323f3768986;
        "sdk_userid" = 18344668;
        "sdk_username" = "19474182.39";
    }*/
    
    /*获取用户唯一标识取result中的sdk_userid字段，
                 获取token取sdk_token字段
    */
    [[OrzOSDK getSharedInstance] showOrzOSDKFloatView];
    
    [self showDialog:[NSString stringWithFormat:@"%@", result] title:@"登录成功"];
}

-(void)loginOrzOSDKFail:(NSDictionary *)result{
    NSLog(@"loginFail , result = %@", result);
}

-(void)logoutOrzOSDKSuccess:(NSDictionary *)result{
    NSLog(@"logoutSuccess , result = %@", result);
}

-(void)logoutOrzOSDKFail:(NSDictionary *)result{
    NSLog(@"logoutFail , result = %@", result);
}

-(void)RegchargOrzOSDKSuccess:(NSDictionary *)result{
    NSLog(@" RegchargOrzOSDKSuccess result = %@", result);

    [self showDialog:[NSString stringWithFormat:@"%@", result] title:@"支付成功"];
}

-(void)RegchargOrzOSDKFail:(NSDictionary *)result{
    NSLog(@"RegchargOrzOSDKFail result = %@", result);
    [self showDialog:[NSString stringWithFormat:@"%@", result] title:@"支付失败"];
}

-(void)openOrzOSDKUserCenter{
    NSLog(@"openUserCenter");
}
-(void)closeOrzOSDKUserCenter{
    NSLog(@"closeUserCenter");
}

-(void)showDialog:(NSString *)msg title:(NSString *)title{
    
    
    dispatch_async(dispatch_get_main_queue(), ^{
        UIAlertController *alertVc = [UIAlertController alertControllerWithTitle:title message:msg preferredStyle:UIAlertControllerStyleActionSheet];
        //默认只有标题 没有操作的按钮:添加操作的按钮 UIAlertAction
        
        UIAlertAction *cancelBtn = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
            NSLog(@"取消");
        }];
        //添加确定
        UIAlertAction *sureBtn = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDestructive handler:^(UIAlertAction * _Nonnull   action) {
            NSLog(@"确定");
        }];
        //设置`确定`按钮的颜色
        [sureBtn setValue:[UIColor redColor] forKey:@"titleTextColor"];
        //将action添加到控制器
        [alertVc addAction:cancelBtn];
        [alertVc addAction :sureBtn];
        //展示
        [self presentViewController:alertVc animated:YES completion:nil];
    });
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
