﻿using System;
using System.Collections.Generic;

namespace Shark
{
	public sealed class TimeUtility 
	{
		public static double CurTimestamp
		{
			get { return (DateTime.Now.AddHours(-8) - new DateTime(1970, 1, 1, 0, 0, 0)).TotalSeconds; }
		}
		public static long AverageRoundtripTime
		{
			get { return s_AverageRoundtripTime; }
			set { s_AverageRoundtripTime = value; }
		}
		public static long RemoteTimeOffset
		{
			get { return s_RemoteTimeOffset; }
			set { s_RemoteTimeOffset = value; }
		}

	/**
	 * TimeUtility中获得当前时间的接口GetServerMilliseconds()，
	 * 改成GetServerMilliseconds(bool ignorePause = true)，
	 * 默认（参数为true）返回刨除暂停时长的时间;参数为false，返回当前时间。
	 * 目前如果非特殊操作，请使用默认参数。
	 */
		public static long GetServerMilliseconds(bool ignorePause = true)
		{
			long val = GetLocalMilliseconds();
			if (GlobalVariables.Instance.IsClient) {

				long t = val + s_RemoteTimeOffset;
				if (ignorePause)
				{
					long nowPause = 0;
					if (s_Instance.m_ClientPauseBeginTime > 0)
					{
						nowPause = GetServerMilliseconds(false) - s_Instance.m_ClientPauseBeginTime;
					}
					t -= (s_Instance.m_ClientPauseTime + nowPause);
				}

				return t;
			} else {
				return val;
			}
		}

		public static long GetLocalMilliseconds()
		{
			return (GetElapsedTimeUs() - s_Instance.m_StartTimeUs) / 1000;
		}
		public static long GetElapsedTimeUs()
		{
			return DateTime.Now.Ticks / 10;
		}
		public static void SampleClientTick()
		{
			long curTime = GetElapsedTimeUs();
			s_Instance.m_ClientDeltaTime = curTime - s_Instance.m_ClientTickTimeUs;
			s_Instance.m_ClientTickTimeUs = curTime;
		}
		public static long GetClientDeltaTime()
		{
			return s_Instance.m_ClientDeltaTime;
		}

		public static void InitClientPauseTime()
		{
			s_Instance.m_ClientPauseTime = 0;
		}
		public static void BeginClientPause()
		{
			s_Instance.m_ClientPauseBeginTime = GetServerMilliseconds(false);
		}
		public static void EndClientPause()
		{
			s_Instance.m_ClientPauseTime += GetServerMilliseconds(false) - s_Instance.m_ClientPauseBeginTime;
			s_Instance.m_ClientPauseBeginTime = 0;
		}

		private static long s_AverageRoundtripTime = 0;
		private static long s_RemoteTimeOffset = 0;
		private static TimeUtility s_Instance = new TimeUtility();

		private TimeUtility()
		{
			m_StartTimeUs = GetElapsedTimeUs();
		}
		private long m_StartTimeUs = 0;
		private long m_ClientTickTimeUs = 0;
		private long m_ClientDeltaTime = 0;

		private long m_ClientPauseTime = 0;
		private long m_ClientPauseBeginTime = 0;
	}

	public sealed class TimeSnapshot
	{
		public static void Start()
		{
			Instance.Start_();
		}
		public static long End()
		{
			return Instance.End_();
		}
		public static long DoCheckPoint()
		{
			return Instance.DoCheckPoint_();
		}

		private void Start_()
		{
			m_LastSnapshotTime = TimeUtility.GetElapsedTimeUs();
			m_StartTime = m_LastSnapshotTime;
		}
		private long End_()
		{
			m_EndTime = TimeUtility.GetElapsedTimeUs();
			return m_EndTime - m_StartTime;
		}
		private long DoCheckPoint_()
		{
			long curTime = TimeUtility.GetElapsedTimeUs();
			long ret = curTime - m_LastSnapshotTime;
			m_LastSnapshotTime = curTime;
			return ret;
		}

		private long m_StartTime = 0;
		private long m_LastSnapshotTime = 0;
		private long m_EndTime = 0;

		private static TimeSnapshot Instance
		{
			get
			{
				if (null == s_Instance) {
					s_Instance = new TimeSnapshot();
				}
				return s_Instance;
			}
		}

		[ThreadStatic]
		private static TimeSnapshot s_Instance = null;
	}
}
