﻿using System;
using System.Globalization;
namespace Shark
{
    public enum ETriggerType
    {
        EInvalid = -1,
        EEveryDay = 0,
        EEveryWeek = 1,
        EFixedTime = 2,
        EIntervalMinutes = 3,//每n分钟执行一次
        EEveryHour = 4,
        EFixedTimeByYear = 5, // 具体时间，格式年月日时分
        EServerOpenTime = 6,
        ESeverOpenedDay = 8,   //开服前三天神绝路活动用到
        EFixedTimeByDay = 9, //具体时间，格式年月日，贺卡用到
        EFixedTimeByMin = 10, //具体时间，格式年月日小时分钟，贺卡用到
        EFixedEndTime = 11,        //黑卡抽奖专用，开服到固定时间结束
    }

    public enum ERefreshType
    {
        Invalid = -1,
        DailyAtFive,        //使用这种方式，MD的设置和判断 都要用TimeCheck.CheckRefreshTime()获取的时间
        Weekly,
        WeeklyAtFive,
        Hour_12_18,
        Daily,
        Month,
        WeeklyAtTuesday,//刚刚过周一24点时
        DayPeriod,
    }

    public class TimeCheck
    {
        public static bool IsTriggerLimitActivity(ETriggerType eType, long nTriggerTime, long nTriggerEndTime)
        {
            bool bTrigger = false;
            switch (eType)
            {
                case ETriggerType.EEveryDay:
                    {
                        if ((DateTime.Now.Hour * 100 + DateTime.Now.Minute) >= nTriggerTime && (DateTime.Now.Hour * 100 + DateTime.Now.Minute) < nTriggerEndTime)
                        {
                            bTrigger = true;
                        }
                    }
                    break;
                case ETriggerType.EEveryWeek:
                    {
                        int nDayOfWeek = (int)DateTime.Now.DayOfWeek == 0 ? 7 : (int)DateTime.Now.DayOfWeek;
                        if ((nDayOfWeek * 10000 + DateTime.Now.Hour * 100 + DateTime.Now.Minute) >= nTriggerTime && (nDayOfWeek * 10000 + DateTime.Now.Hour * 100 + DateTime.Now.Minute) < nTriggerEndTime)
                        {
                            bTrigger = true;
                        }
                    }
                    break;
                case ETriggerType.EFixedTime:
                case ETriggerType.EServerOpenTime:
                    {
                        if ((DateTime.Now.Year * 100000000L + DateTime.Now.Month * 1000000 + DateTime.Now.Day * 10000 + DateTime.Now.Hour * 100 + DateTime.Now.Minute) >= nTriggerTime &&
                            (DateTime.Now.Year * 100000000L + DateTime.Now.Month * 1000000 + DateTime.Now.Day * 10000 + DateTime.Now.Hour * 100 + DateTime.Now.Minute) < nTriggerEndTime)
                        {
                            bTrigger = true;
                        }
                    }
                    break;
                case ETriggerType.EIntervalMinutes:
                    {
                        if (nTriggerTime != 0 && (DateTime.Now.Hour * 60 + DateTime.Now.Minute) % nTriggerTime == 0)
                        {
                            bTrigger = true;
                        }
                    }
                    break;

                default:
                    bTrigger = false;
                    break;
            }
            return bTrigger;
        }

        public static bool IsTrigger(ETriggerType eType, long nTriggerTime)
        {
            bool bTrigger = false;
            switch (eType)
            {
                case ETriggerType.EEveryDay:
                    {
                        if ((DateTime.Now.Hour * 100 + DateTime.Now.Minute) == nTriggerTime)
                        {
                            bTrigger = true;
                        }
                    }
                    break;
                case ETriggerType.EEveryWeek:
                    {
                        int nDayOfWeek = (int)DateTime.Now.DayOfWeek == 0 ? 7 : (int)DateTime.Now.DayOfWeek;
                        if ((nDayOfWeek * 10000 + DateTime.Now.Hour * 100 + DateTime.Now.Minute) == nTriggerTime)
                        {
                            bTrigger = true;
                        }
                    }
                    break;
                case ETriggerType.EFixedTimeByDay:
                    if ((DateTime.Now.Year * 10000 + DateTime.Now.Month * 100 + DateTime.Now.Day) == nTriggerTime)
                    {
                        bTrigger = true;
                    }
                    break;
                case ETriggerType.EFixedTimeByMin:
                    if ((DateTime.Now.Month * 1000000 + DateTime.Now.Day * 10000 + DateTime.Now.Hour * 100 + DateTime.Now.Minute) == nTriggerTime)
                    {
                        bTrigger = true;
                    }
                    break;
                case ETriggerType.EFixedTime:
                case ETriggerType.EServerOpenTime:
                    {
                        if ((DateTime.Now.Year * 100000000L + DateTime.Now.Month * 1000000 + DateTime.Now.Day * 10000 + DateTime.Now.Hour * 100 +
                             DateTime.Now.Minute) == nTriggerTime)
                        {
                            bTrigger = true;
                        }
                    }
                    break;
                case ETriggerType.EIntervalMinutes:
                    {
                        if (nTriggerTime != 0 && (DateTime.Now.Hour * 60 + DateTime.Now.Minute) % nTriggerTime == 0)
                        {
                            bTrigger = true;
                        }
                    }
                    break;
                default:
                    bTrigger = false;
                    break;
            }
            return bTrigger;
        }

        public static bool IsTriggerMyTime(ETriggerType eType, long nTriggerTime, DateTime dtTime)
        {
            bool bTrigger = false;
            switch (eType)
            {
                //case ETriggerType.EEveryDay:
                //    {
                //        if ((dtTime.Hour * 100 + dtTime.Minute) == nTriggerTime)
                //        {
                //            bTrigger = true;
                //        }
                //    }
                //    break;
                //case ETriggerType.EEveryWeek:
                //    {
                //        int nDayOfWeek = (int)dtTime.DayOfWeek == 0 ? 7 : (int)dtTime.DayOfWeek;
                //        if ((nDayOfWeek * 10000 + dtTime.Hour * 100 + dtTime.Minute) == nTriggerTime)
                //        {
                //            bTrigger = true;
                //        }
                //    }
                //    break;
                //case ETriggerType.EFixedTimeByDay:
                //    if ((dtTime.Year * 10000 + dtTime.Month * 100 + dtTime.Day) == nTriggerTime)
                //    {
                //        bTrigger = true;
                //    }
                //    break;
                //case ETriggerType.EFixedTimeByMin:
                //    if ((dtTime.Month * 1000000 + dtTime.Day * 10000 + dtTime.Hour * 100 + dtTime.Minute) == nTriggerTime)
                //    {
                //        bTrigger = true;
                //    }
                //    break;
                case ETriggerType.EFixedTime:
                case ETriggerType.EServerOpenTime:
                    {
                        if ((dtTime.Year * 100000000L + dtTime.Month * 1000000 + dtTime.Day * 10000 + dtTime.Hour * 100 +
                             dtTime.Minute) <= nTriggerTime)
                        {
                            bTrigger = true;
                        }
                    }
                    break;
                //case ETriggerType.EIntervalMinutes:
                //    {
                //        if (nTriggerTime != 0 && (dtTime.Hour * 60 + dtTime.Minute) % nTriggerTime == 0)
                //        {
                //            bTrigger = true;
                //        }
                //    }
                //    break;
                default:
                    bTrigger = false;
                    break;
            }
            return bTrigger;
        }

        public static int CheckRefreshTime(int nLastRefreshTime, ERefreshType eType)
        {
            switch (eType)
            {
                case ERefreshType.Daily:
                    {
                        int nNowDay = DateTime.Now.Year % 100 * 10000 + DateTime.Now.Month * 100 + DateTime.Now.Day;
                        if (nNowDay != nLastRefreshTime)
                        {
                            nLastRefreshTime = nNowDay;
                        }
                    }
                    break;
                case ERefreshType.DailyAtFive:
                    {
                        DateTime timeRgrss = DateTime.Now.AddHours(-5);
                        int nNowDay = timeRgrss.Year % 100 * 10000 + timeRgrss.Month * 100 + timeRgrss.Day;
                        if (nNowDay != nLastRefreshTime)
                        {
                            nLastRefreshTime = nNowDay;
                        }
                    }
                    break;
                case ERefreshType.Weekly:
                    {
                        int nNowWekk = CalcWeekData(DateTime.Now);
                        if (nNowWekk != nLastRefreshTime)
                        {
                            nLastRefreshTime = nNowWekk;
                        }
                    }

                    break;
                case ERefreshType.WeeklyAtFive:
                    {
                        int nNowWekk = CalcWeekData(DateTime.Now.AddHours(-5));
                        if (nNowWekk != nLastRefreshTime)
                        {
                            nLastRefreshTime = nNowWekk;
                        }
                    }
                    break;
                case ERefreshType.Hour_12_18:
                    {
                        int nNowTime = DateTime.Now.Year % 100 * 10000 + DateTime.Now.Month * 100 + DateTime.Now.Day;
                        if (DateTime.Now.Hour >= 18)
                        {
                            DateTime vTmr = DateTime.Now.AddDays(1);
                            nNowTime = vTmr.Year % 100 * 10000 + vTmr.Month * 100 + vTmr.Day;
                            nNowTime = nNowTime * 100 + 8;
                        }
                        else if (DateTime.Now.Hour < 8)
                        {
                            nNowTime = nNowTime * 100 + 8;
                        }
                        else if (DateTime.Now.Hour >= 12)
                        {
                            nNowTime = nNowTime * 100 + 18;
                        }
                        else
                        {
                            nNowTime = nNowTime * 100 + 12;
                        }

                        if (nLastRefreshTime != nNowTime)
                        {
                            nLastRefreshTime = nNowTime;
                        }
                    }
                    break;
                case ERefreshType.Month:
                    {
                        DateTime timeRgrss = DateTime.Now.AddHours(-5);
                        int nNowDay = timeRgrss.Year % 100 * 100 + timeRgrss.Month;
                        if (nNowDay != nLastRefreshTime)
                        {
                            nLastRefreshTime = nNowDay;
                        }
                    }
                    break;
                case ERefreshType.WeeklyAtTuesday:
                    {
                        int nNowWekk = CalcWeekData(DateTime.Now.AddHours(-24));
                        if (nNowWekk != nLastRefreshTime)
                        {
                            nLastRefreshTime = nNowWekk;
                        }
                    }
                    break;
                case ERefreshType.DayPeriod:
                    {
                        int nNowDay = DateTime.Now.Year % 100 * 10000 + DateTime.Now.Month * 100 + DateTime.Now.Day;
                        if (nNowDay > nLastRefreshTime)
                        {
                            nLastRefreshTime = nNowDay;
                        }
                    }
                    break;
                default:
                    break;
            }
            return nLastRefreshTime;
        }
        public static int CalcWeekData(DateTime dateTime)
        {
            int nDays = (int)(dateTime - new DateTime(1980, 1, 7, 0, 0, 0)).TotalDays;

            return nDays / 7;
        }
        public static bool IsTrigger_BeginTime(ETriggerType eType, int nBeginTime,long nServerOpenTime=-1)
        {
            bool bTrigger = false;
            switch (eType)
            {
                case ETriggerType.EEveryDay:
                    if ((DateTime.Now.Hour * 100 + DateTime.Now.Minute) >= nBeginTime)
                    {
                        bTrigger = true;
                    }
                    break;
                case ETriggerType.EEveryWeek:
                    int nDayOfWeek = (int)DateTime.Now.DayOfWeek == 0 ? 7 : (int)DateTime.Now.DayOfWeek;
                    int nNowTime = nDayOfWeek * 10000 + DateTime.Now.Hour * 100 + DateTime.Now.Minute;
                    if (nNowTime >= nBeginTime)
                    {
                        bTrigger = true;
                    }
                    break;
                case ETriggerType.EFixedTime:
                    if ((DateTime.Now.Month * 1000000 + DateTime.Now.Day * 10000 + DateTime.Now.Hour * 100 +
                         DateTime.Now.Minute) >= nBeginTime)
                    {
                        bTrigger = true;
                    }
                    break;
                case ETriggerType.ESeverOpenedDay:
                    int nOpenYear = (int)(nServerOpenTime / 100000000);
                    DateTime vCurTime = DateTime.Now;
                    if (nOpenYear == vCurTime.Year)
                    {
                        int lStartTime = (int)(nServerOpenTime % 100000000);
                        int lBeginTime = lStartTime + nBeginTime - 10000;
                        int lCurTime = vCurTime.Month * 1000000 + vCurTime.Day * 10000 + vCurTime.Hour * 100 + vCurTime.Minute;
                        if (lBeginTime / 10000 == lCurTime / 10000)
                        {
                            if (lCurTime >= lBeginTime)
                            {
                                bTrigger = true;
                            }
                        }
                    }
                    break;
            }
            return bTrigger;
        }

        public static bool IsTrigger_EndTime(ETriggerType eType, int nEndTime, long nServerOpenTime = -1)
        {
            bool bTrigger = false;
            switch (eType)
            {
                case ETriggerType.EEveryDay:
                    if ((DateTime.Now.Hour * 100 + DateTime.Now.Minute) <= nEndTime)
                    {
                        bTrigger = true;
                    }
                    break;
                case ETriggerType.EEveryWeek:
                    int nDayOfWeek = (int)DateTime.Now.DayOfWeek == 0 ? 7 : (int)DateTime.Now.DayOfWeek;
                    int nNowTime = nDayOfWeek * 10000 + DateTime.Now.Hour * 100 + DateTime.Now.Minute;
                    if (nNowTime < nEndTime)
                    {
                        bTrigger = true;
                    }
                    break;
                case ETriggerType.EFixedTime:
                    if ((DateTime.Now.Month * 1000000 + DateTime.Now.Day * 10000 + DateTime.Now.Hour * 100 +
                         DateTime.Now.Minute) < nEndTime)
                    {
                        bTrigger = true;
                    }
                    break;
                case ETriggerType.ESeverOpenedDay:
                    int nOpenYear = (int)(nServerOpenTime / 100000000);
                    DateTime vCurTime = DateTime.Now;
                    if (nOpenYear == vCurTime.Year)
                    {
                        int lStartTime = (int)(nServerOpenTime % 100000000);
                        int lEndTime = lStartTime + nEndTime - 10000;
                        int lCurTime = vCurTime.Month * 1000000 + vCurTime.Day * 10000 + vCurTime.Hour * 100 + vCurTime.Minute;
                        if (lEndTime / 10000 == lCurTime / 10000)
                        {
                            if (lCurTime < lEndTime)
                            {
                                bTrigger = true;
                            }
                        }
                    }
                    break;
            }
            return bTrigger;
        }

        public static bool IsInOpenTime(ETriggerType eType, int nStartTime, int nEndTime)
        {
            bool bInTime = false;
            switch (eType)
            {
                case ETriggerType.EEveryDay:
                    {
                        int time = DateTime.Now.Hour * 100 + DateTime.Now.Minute;
                        if (time >= nStartTime && time <= nEndTime)
                        {
                            bInTime = true;
                        }
                    }
                    break;
                case ETriggerType.EEveryWeek:
                    {
                        int nDayOfWeek = (int)DateTime.Now.DayOfWeek == 0 ? 7 : (int)DateTime.Now.DayOfWeek;
                        int time = nDayOfWeek * 10000 + DateTime.Now.Hour * 100 + DateTime.Now.Minute;
                        if (time >= nStartTime && time < nEndTime)
                        {
                            bInTime = true;
                        }
                    }
                    break;
                case ETriggerType.EFixedTime:
                    {
                        int time = DateTime.Now.Month * 1000000 + DateTime.Now.Day * 10000 + DateTime.Now.Hour * 100 +
                                   DateTime.Now.Minute;
                        if (time >= nStartTime && time < nEndTime)
                        {
                            bInTime = true;
                        }
                    }
                    break;
                default:
                    bInTime = true;
                    break;
            }
            return bInTime;
        }


        public static bool IsInOpenTimeByEndTime(ETriggerType eType, int durationMin, long nStartTime)
        {
            if (durationMin <=0 && nStartTime <= 0)
            {
                return false;
            }

            bool bInTime = false;
            DateTime startDataTime = StartTimeForFixTrigerTypeByYerr(nStartTime);

            DateTime endDataTime = startDataTime.AddMinutes(durationMin);

            switch (eType)
            {
                case ETriggerType.EFixedTime:
                case ETriggerType.EServerOpenTime:
                    {
                        if (DateTime.Now > startDataTime && DateTime.Now < endDataTime)
                        {
                            bInTime =  true;
                        }
                        break;
                    }

                default:
                    bInTime = false;
                    break;
            }

            return bInTime;
        }

        public static bool IsInOpenTimeByEndTime(ETriggerType eType, int durationMin, DateTime endDateTime)
        {
            if (durationMin > 0 && endDateTime != null)
            {
                DateTime startTime = endDateTime.AddMinutes(-durationMin);

                switch (eType)
                {
                    case ETriggerType.EFixedTime:
                    case ETriggerType.EServerOpenTime:
                        {
                            if (DateTime.Now > startTime && DateTime.Now < endDateTime)
                            {
                                return true;
                            }
                            break;
                        }
                    case ETriggerType.EFixedEndTime:
                        if (DateTime.Now < endDateTime)
                        {
                            return true;
                        }
                        break;
                    default:
                        return false;
                }
            }
            return false;
        }


        public static bool IsInOpenTimeByDurMin(ETriggerType eType, long nStartTime, int durationMin, int deferMin = 0)
        {
            bool bInTime = false;

            DateTime startDataTime = StartTimeForFixTrigerTypeByYerr(nStartTime);
            if (deferMin > 0)
            {
                startDataTime = startDataTime.AddMinutes(deferMin);
            }
            DateTime endDataTime = startDataTime.AddMinutes(durationMin);

            switch (eType)
            {
                case ETriggerType.EFixedTime:
                    {
                        if (DateTime.Now > startDataTime && DateTime.Now < endDataTime)
                        {
                            bInTime = true;
                        }
                    }
                    break;
                default:
                    bInTime = false;
                    break;
            }
            return bInTime;
        }
        public static bool IsInSameTimeRange(ETriggerType eType, long lLastTime)
        {
            DateTime vLastTime = new DateTime(lLastTime * 10000);

            if (vLastTime.Year != DateTime.Now.Year)
            {
                return false;
            }
            switch (eType)
            {
                case ETriggerType.EEveryDay:
                    return vLastTime.DayOfYear == DateTime.Now.DayOfYear;
                case ETriggerType.EEveryWeek:
                    return WeekOfYear(vLastTime) == WeekOfYear(DateTime.Now);
            }
            return false;
        }

        public static int WeekOfYear(DateTime dateTime)
        {
            GregorianCalendar ci = new GregorianCalendar();
            return ci.GetWeekOfYear(dateTime, CalendarWeekRule.FirstDay, (DayOfWeek.Monday));
        }
        //看清楚了只是ETriggerType.EFixedTime，年月日时分
        public static DateTime StartTimeForFixTrigerTypeByYerr(long nTime)
        {
            int nYear = (int)(nTime / 100000000);
            int nMonth = (int)(nTime / 1000000 % 100);
            int nDay = (int)(nTime / 10000 % 100);
            int nHour = (int)(nTime / 100 % 100);
            int nMin = (int)(nTime % 100);

            try
            {
                return new DateTime(nYear, nMonth, nDay, nHour, nMin, 0);
            }
            catch (Exception e)
            {
                return new DateTime(nYear, nMonth, nDay, nHour, nMin, 0);
            }
            finally
            {
                //return new DateTime(nYear, nMonth, nDay, nHour, nMin, 0);
                //return new DateTime();
            }
        }

        public static DateTime GetDateTime(long nTime)
        {
            int nYear = (int)(nTime / 100000000);
            int nMonth = (int)(nTime / 1000000 % 100);
            int nDay = (int)(nTime / 10000 % 100);
            int nHour = (int)(nTime / 100 % 100);
            int nMinu = (int)(nTime % 100);

            return new DateTime(nYear, nMonth, nDay, nHour, nMinu, 0);
        }


        public static DateTime StartTimeForFixTrigerType(int nTime, long durationMin, long nEndTime = -1)
        {
            try
            {
                if (nEndTime != -1)
                {
                    if (durationMin < 0)
                    {
                        return DateTime.Now;
                    }
                    int nMonth = (int)(durationMin / 43200);
                    int nDay = (int)((durationMin % 43200) / 1440);
                    int nHour = (int)(((durationMin % 43200) % 1440) / 60);
                    int nMin = (int)(((durationMin % 43200) % 1440) % 60);
                    DateTime St = StartTimeForFixTrigerTypeByYerr(nEndTime).AddMonths(-nMonth);
                    St = St.AddDays(-nDay);
                    St = St.AddHours(-nHour);
                    St = St.AddMinutes(-nMin);
                    //long nStartTime = (long)St.Year * 100000000 + (long)St.Month * 1000000 + (long)St.Day * 10000 + (long)St.Hour * 100 +
                    //                       (long)St.Minute;
                    return new DateTime(St.Year, St.Month, St.Day, St.Hour, St.Minute, 0);
                }
                else
                {
                    int nYear = DateTime.Now.Year;
                    int nMonth = nTime / 1000000;
                    int nDay = nTime / 10000 % 100;
                    int nHour = nTime / 100 % 100;
                    int nMin = nTime % 100;
                    return new DateTime(nYear, nMonth, nDay, nHour, nMin, 0);
                }


            }
            catch
            {
                return DateTime.Now;
            }
        }
        //看清楚了只是ETriggerType.EFixedTime，月日时分
        public static DateTime StartTimeForFixTrigerType(int nTime)
        {
            try
            {
                int nYear = DateTime.Now.Year;
                int nMonth = nTime / 1000000;
                int nDay = nTime / 10000 % 100;
                int nHour = nTime / 100 % 100;
                int nMin = nTime % 100;

                return new DateTime(nYear, nMonth, nDay, nHour, nMin, 0);
            }
            catch
            {
                return DateTime.Now;
            }
        }

        public static int GetShenYuUserRefreshTime(bool isTimeCheck)
        {
            DateTime date;
            if (isTimeCheck)
            {
                date = DateTime.Now.AddHours(-5);
            }
            else
            {
                date = DateTime.Now.AddDays(1).AddHours(-5);
            }

            return GetShenYuRefreshTime(date);
        }
        public static int GetShenYuServerRefreshTime(bool isTimeCheck)
        {
            DateTime date;
            if (isTimeCheck)
            {
                date = DateTime.Now.AddHours(-5).AddMinutes(1);
            }
            else
            {
                date = DateTime.Now.AddDays(1).AddHours(-5);
            }

            return GetShenYuRefreshTime(date);
        }

        public static int GetShenYuRefreshTime(DateTime date)
        {
            int weak = (date.DayOfWeek == DayOfWeek.Sunday ? 7 : (int)date.DayOfWeek) - (int)DayOfWeek.Wednesday;
            if (weak < 0)
            {
                weak += 7;
            }
            date = date.AddDays(-weak);
            return date.Year * 10000 + date.Month * 100 + date.Day;
        }

        public static int GetTimeValue(DateTime time)
        {
            return time.Month * 100000000 + time.Day * 1000000 + (time.Year % 100) * 10000 + time.Hour * 100 + time.Minute;
        }

        public static DateTime GetTime(int time)
        {
            try
            {
                int year = 2000 + (time / 10000 % 100);
                int month = time / 100000000;
                int day = time / 1000000 % 100;
                int hour = time / 100 % 100;
                int minute = time % 100;
                return new DateTime(year, month, day, hour, minute, 0);
            }
            catch (Exception)
            {
                return DateTime.Now;
            }
        }

        public static bool IsAfterDays(DateTime date, int days)
        {
            bool match = false;
            if (days > 0)
            {
                date = date.AddDays(days);
                if (DateTime.Now >= date)
                {
                    match = true;
                }
            }
            else
            {
                match = true;
            }
            return match;
        }

        public static int GetAfterDaysTime(int time, int days)
        {
            DateTime date;
            try
            {
                date = new DateTime(time / 10000, (time / 100) % 100, time % 100).AddDays(days);
            }
            catch (Exception)
            {
                date = DateTime.Now.AddDays(days);
            }
            return date.Year % 100 * 10000 + date.Month * 100 + date.Day;
        }
        
        public static int GetDayIndex(DateTime date)
        {
            return date.Year * 1000 + date.DayOfYear;
        }

        public static long GetTimeLongValue(DateTime time)
        {
            return time.Year * 100000000L + time.Month * 1000000 + time.Day * 10000 + time.Hour * 100 + time.Minute;
        }

        public static bool IsSameDay(DateTime time1, DateTime time2)
        {
            return time1.Year == time2.Year && time1.DayOfYear == time2.DayOfYear;
        }

    }
}

