﻿using System;
using System.Collections.Generic;
using System.Threading;

namespace Shark
{
    public class RandomHelper
    {
        /*
        static int seed = Environment.TickCount;
        public static readonly ThreadLocal<RandomHelper> RandomThreadLocal =
            new ThreadLocal<RandomHelper>(() => new RandomHelper(Interlocked.Increment(ref seed)));

        private readonly BingoRandom _random;

        public static  RandomHelper Instance { get { return RandomThreadLocal.Value; } }
        */

        private static int _seed = Environment.TickCount;
        private readonly BingoRandom _random;

        [ThreadStatic] private static RandomHelper _randomHelper;

        public static RandomHelper Instance
        {
            get
            {
                if (_randomHelper == null)
                {
                    _randomHelper = new RandomHelper(Interlocked.Increment(ref _seed));
                }
                return _randomHelper;
            }
        }

        private RandomHelper(int seed)
        {
            _random = new BingoRandom(seed);
        }

        public int NextInt()
        {
            return _random.Next();
        }

        public double NextDouble()
        {
            return _random.NextDouble();
        }


        // return [nMin,nMax)
        public int Range(int nMin, int nMax)
        {
            var res = _random.Next(nMin, nMax);
            //Console.WriteLine("get random instance: {0}, value {1}", _random.GetHashCode(), res);
            return res;
        }

		
        public int RangeMillion()
        {
            return Range(0,1000000);
        }


         //n个不重复随机数[min,max]
        public  int[] RandomArray(int min, int max, int n)
        {
            int len = max - min + 1;




            if (max < min)
            {
                return null;
            }
            //初始化给定范围的待选数组  
            int[] source = new int[len];
            for (int i = min; i < min + len; i++)
            {
                source[i - min] = i;
            }

            if (n > len)
            {
                return source;
            }

            int[] result = new int[n];

            int index = 0;
            for (int i = 0; i < result.Length; i++)
            {
                index = Math.Abs(NextInt() % len--);
                result[i] = source[index];
                source[index] = source[len];
            }
            return result;
        }

        //n个不重复随机数[0,max],如果n大于max + 1,则生成循环
        public int[] RandomArrayNew(int max, int n)
        {
            if (max < 0)
            {
                return null;
            }
            int len = max + 1;
            int[] source;
            if (n > len)
            {
                source = new int[n];
                for (int i = 0; i < n; i++)
                {
                    if (max > 0)
                    {
                        source[i] = i % max;
                    }
                    else
                    {
                        source[i] = 0;
                    }
                }
                return source;
            }
            //初始化给定范围的待选数组  
            source = new int[len];
            for (int i = 0; i < len; i++)
            {
                source[i] = i;
            }
            int[] result = new int[n];
            for (int i = 0; i < result.Length; i++)
            {
                int index = Math.Abs(NextInt() % len--);
                result[i] = source[index];
                source[index] = source[len];
            }
            return result;
        }

        public T RandomWeight<T>(List<WeightItem<T>> list)
        {
            int bingo = 0;
            int totalWeight = 0;
            for (int i = 0; i < list.Count; i++)
            {
                if (list[i].Weight <= 0)
                {
                    continue;
                }
                totalWeight += list[i].Weight;
            }
            int random = _random.Next(totalWeight);
            for (int i = 0; i < list.Count; i++)
            {
                if (random < list[i].Weight)
                {
                    bingo = i;
                    break;
                }
                random -= list[i].Weight;
            }
            return list[bingo].Data;
        }

    }

    public class WeightItem<T>
    {
        public int Weight { get; set; }
        public T Data { get; set; }
        public WeightItem(int w, T t)
        {
            Weight = w;
            Data = t;
        }
    }
}
