﻿using System;
using System.IO;
using UnityEngine;
using System.Collections.Generic;
using System.Linq;
using System.Text.RegularExpressions;

namespace Shark
{
    public class MyUtility
    {
        public static float _2P = 6.283185f;

        public static int Float2Int45(float fVal)
        {
            return fVal > 0.0f ? (int)(fVal + 0.5f) : (int)(fVal - 0.5);
        }

        public static float CalcDirectionDiff(float dir1, float dir2)
        {
            return Math.Min(NormaliseDirection(dir1 - dir2), NormaliseDirection(dir2 - dir1));
        }
        public static float CaclDirection(UnityEngine.Vector3 vStartPos, UnityEngine.Vector3 vEndPos)
        {
            float fRet = 0.0f;
            if (vStartPos != vEndPos)
            {
                fRet = (float)Math.Atan2((double)(vEndPos.z - vStartPos.z), (double)(vEndPos.x - vStartPos.x));
                fRet = NormaliseDirection(fRet);
            }
            return fRet;
        }
        public static float GetDistance2D(Vector3 vPosStart, Vector3 vPosEnd)
        {
            return Mathf.Sqrt(GetDistance2DSquare(vPosStart, vPosEnd));
        }
        public static float GetDistance2DSquare(Vector3 vPosStart, Vector3 vPosEnd)
        {
            return (vPosEnd.x - vPosStart.x) * (vPosEnd.x - vPosStart.x) + (vPosEnd.z - vPosStart.z) * (vPosEnd.z - vPosStart.z);
        }
        public static float NormaliseDirection(float fDir)
        {
            float fRet = fDir;
            if (fRet >= _2P)
            {
                fRet -= ((int)(fRet / _2P)) * _2P;
            }
            if (fRet < 0f)
            {
                fRet += ((int)(fRet / _2P)) * _2P;
            }
            return fRet;
        }

        public static float CalcCombatPowerByAdd(int nAttrValue, int nPropertyType)
        {
            float nCombatValue = 0;

            Tab_AttrPowerBase vData = Tab_AttrPowerBaseProvider.Instance.GetDataById(nPropertyType);
            if (vData != null)
            {
                nCombatValue += nAttrValue * vData.Ratio;
            }

            return nCombatValue;
        }

        public const string DangerousPattern = "[\u0020\u00A0\u00BC-\u00BE\u01C3\u02D0\u0337-\u0338\u0589-\u058A\u05C3\u05F4\u0609-\u060A\u066A\u06D4\u0701-\u0704\u115F-\u1160\u1735\u2000-\u200B\u200E-\u2010\u2019\u2024\u2027-\u202F\u2039-\u203A\u2041\u2044\u2052\u205F\u2153-\u215F\u2215\u2236\u23AE\u2571\u29F6\u29F8\u2AFB\u2AFD\u2FF0-\u2FFB\u3000\u3002\u3014-\u3015\u3033\u30A0\u3164\u321D-\u321E\u33AE-\u33AF\u33C6\u33DF\uA789\uFE14-\uFE15\uFE3F\uFE5D-\uFE5E\uFEFF\uFF0E-\uFF0F\uFF61\uFFA0\uFFF9-\uFFFD]";

        public static readonly char[] specialSymbol = { '/', '\\', '?', '*', ':', '"', '<', '>', '|', ' ', '!', '\'', '\r', '\n', '\t', '#', ',', ';' };

        public static bool ContainSpecialSymbol(string strUserName)
        {
            for (int i = 0; i < specialSymbol.Length; ++i)
            {
                if (strUserName.Contains(specialSymbol[i]))
                {
                    return true;
                }
            }

            if (Regex.IsMatch(strUserName, @"\p{Cs}"))
            {
                return true;
            }

            if (Regex.IsMatch(strUserName, DangerousPattern))
            {
                return true;
            }

            if (strUserName.Contains("　"))
            {
                return true;
            }

            return false;
        }
        public static EChangeNameResule CanUseName(string strName)
        {
            if (string.IsNullOrEmpty(strName))
            {
                return EChangeNameResule.Field_Min;
            }

            if (ContainSpecialSymbol(strName))
            {
                return EChangeNameResule.Field_Symbol;
            }

            if (strName.Length < GameDefineCom.MinCreateRoleNameCount)
            {
                return EChangeNameResule.Field_Min;
            }

            if (strName.Length > GameDefineCom.MaxCreateRoleNameCount)
            {
                return EChangeNameResule.Field_Max;
            }

            return EChangeNameResule.Success;
        }

        public static bool IsActivityTimeLimited(int nActivityID)
        {
            Tab_ActivityBase vBase = Tab_ActivityBaseProvider.Instance.GetDataById(nActivityID);
            if (vBase != null && vBase.OpenTimeType != 6)
            {
                //暂不开放
                if (vBase.ActivityType == -1)
                {
                    return true;
                }
                List<bool> vFlagList = new List<bool>();
                for (int i = 0; i < vBase.OpenTimeList.Count; i++)
                {
                    if (vBase.OpenTimeList[i] != -1 && vBase.EndTimeList[i] != -1)
                    {
                        bool bBeginTime = TimeCheck.IsTrigger_BeginTime((ETriggerType)vBase.OpenTimeType, vBase.OpenTimeList[i]);
                        bool bEndTime = TimeCheck.IsTrigger_EndTime((ETriggerType)vBase.OpenTimeType, vBase.EndTimeList[i]);
                        if (bBeginTime && bEndTime)
                        {
                            vFlagList.Add(true);
                        }
                        else
                        {
                            vFlagList.Add(false);
                        }
                    }
                }
                bool bJudge = false;
                for (int i = 0; i < vFlagList.Count; i++)
                {
                    if (vFlagList[i] && true)
                    {
                        bJudge = true;
                        break;
                    }
                    else
                    {
                        bJudge = false;
                    }
                }
                if (!bJudge)
                {
                    return true;
                }
            }
            return true;
        }

        public static UnityEngine.Vector3 GetWanMoDaoRandomPos(out int nIndex)
        {
            nIndex = 0;
            Tab_SceneClass vSceneClass = Tab_SceneClassProvider.Instance.GetDataById(GameDefineCom.WanMoDaoSceneId);
            if (vSceneClass == null)
            {
                return UnityEngine.Vector3.zero;
            }

            int nRandom = RandomHelper.Instance.Range(0, 2);
            Tab_SceneSafeZone vSafe = null;
            if (nRandom == 0)
            {
                vSafe = Tab_SceneSafeZoneProvider.Instance.GetDataById(GameDefineCom.WanMoDaoRandomReLivePointId1);
                nIndex = 0;
            }
            else
            {
                vSafe = Tab_SceneSafeZoneProvider.Instance.GetDataById(GameDefineCom.WanMoDaoRandomReLivePointId2);
                nIndex = 1;
            }
            if (vSafe != null)
            {
                return new UnityEngine.Vector3(vSafe.PosX, 0, vSafe.PosZ);
            }

            return new UnityEngine.Vector3(vSceneClass.Entry_x, vSceneClass.Entry_y, vSceneClass.Entry_z);
        }


        public static UnityEngine.Vector3 GetBattlefieldRandomPos(EBattleCamp eBattleCamp)
        {
            Tab_SceneClass vSceneClass = Tab_SceneClassProvider.Instance.GetDataById(GameDefineCom.BattlefieldSceneClassId);
            if (vSceneClass == null)
            {
                return UnityEngine.Vector3.zero;
            }

            Tab_SceneSafeZone vSafe = null;

            if (eBattleCamp == EBattleCamp.Type_Red)
            {
                vSafe = Tab_SceneSafeZoneProvider.Instance.GetDataById(GameDefineCom.BattlefieldRandomReLivePointId1);
            }
            else
            {
                vSafe = Tab_SceneSafeZoneProvider.Instance.GetDataById(GameDefineCom.BattlefieldRandomReLivePointId2);
            }
            if (vSafe != null)
            {
                return new UnityEngine.Vector3(vSafe.PosX, 0, vSafe.PosZ);
            }

            return new UnityEngine.Vector3(vSceneClass.Entry_x, vSceneClass.Entry_y, vSceneClass.Entry_z);
        }

        public static bool IsInShenMoJiangYuScene(int nSceneId)
        {
            if (nSceneId >= GameDefineCom.ShenMoJiangYuSceneIdStart && nSceneId <= GameDefineCom.ShenMoJiangYuSceneIdEnd)
            {
                return true;
            }
            return false;
        }

    }
}
