using System;
namespace Shark
{
	public class BitOperator
	{
		public static bool GetBitFlag(byte[] btArray, int iIndex)
		{
			if (btArray == null)
			{
				return false;
			}
			if (iIndex >= btArray.Length * 8 || iIndex < 0)
			{
				return false;
			}

			byte b = (byte)(1 << (iIndex % 8));
			return (b & btArray[iIndex>>3]) == b;
		}
		public static bool GetBitFlag(int nValue, int iIndex)
		{
			if (iIndex > 31)
			{
				return false;
			}
			int num = 1 << iIndex;
			return (num & nValue) == num;
		}

        public static int SetBitFlag(int nValue,int iIndex,bool bFlag)
        {
            if(iIndex >31)
            {
                return nValue;
            }
            if(bFlag)
            {
                nValue = nValue | (1 << iIndex);
            }
            else
            {
                nValue = nValue & ~(1 << iIndex);
            }
            return nValue;
        }

        public static bool GetBitFlag(long lValue, int iIndex)
        {
            if (iIndex > 63)
            {
                return false;
            }
            long num = 1L << iIndex;
            return (num & lValue) == num;
        }

        public static long SetBitFlag(long lValue, int iIndex, bool bFlag)
        {
            if (iIndex > 63)
            {
                return lValue;
            }
            if (bFlag)
            {
                lValue = lValue | (1L << iIndex);
            }
            else
            {
                lValue = lValue & ~(1L << iIndex);
            }
            return lValue;
        }

		public static bool SetBitFlag(byte[] btArray, int iIndex, bool bFlag)
		{
			if (btArray == null)
			{
				return false;
			}
			if (iIndex >= btArray.Length * 8 || iIndex < 0)
			{
				return false;
			}

			byte b = (byte)(1 << (iIndex % 8));
			if (bFlag)
			{
				btArray[iIndex>>3] |= b;
			}
			else
			{
				btArray[iIndex>>3] &= (byte)(~b);
			}
			return true;
		}
	}

}