﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Shark
{
	public class GuideSetData
	{
		private List<int> guideLists = new List<int>();
		public List<int> GuideLists
		{
			get { return guideLists; }
		}
		public void Reset()
		{
			guideLists.Clear();
		}
		public string GetString()
		{
			string strRet = "";
			int ct = guideLists.Count;
			for (int i = 0; i < ct; i++)
			{
				if (i == ct - 1)
					strRet += guideLists[i];
				else
					strRet += guideLists[i] + "#";
			}
			return strRet;
		}
		public void SetString(string value)
		{
			if (string.IsNullOrEmpty(value))
				return;
			string[] vals = value.Split(new char[] { '#' }, StringSplitOptions.RemoveEmptyEntries);
			//if(vals != null)
			{
				guideLists.Clear();
				int ct = vals.Length;
				for(int i=0; i<ct; i++)
				{
					int nTmp = 0;
					if (Int32.TryParse(vals[i], out nTmp))
					{
						guideLists.Add(nTmp);
					}
					else
					{
						throw (new Exception(string.Format("!!!!!!!!!!!!  GuideSetData  {0}",vals[i])));
					}

				}
			}
		}
		public byte[] GetByte()
		{
			byte[] ret = System.Text.Encoding.ASCII.GetBytes(GetString());
			return ret;
		}
		public void SetByte(byte[] data)
		{
			string strData = System.Text.Encoding.ASCII.GetString(data);
			SetString(strData);
		}
	}
}
