﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Shark
{
	public class GuardCastleInfo
	{
		public int mId;             // ID
		public bool mIsOpen;        // 是否开启
		public string mName;        // 名字
		public int mRecomendLv;     // 推荐等级
		public int mLimitTime;      // 限时;
		public int mKillMonster;    // 击杀怪物;
		public int mDropId;        // 掉落ID
		public int mConsumeCardId;  // 消耗令牌ID;

		public GuardCastleInfo()
		{
			mId = 0;
			mIsOpen = false;
			mName = "";
			mRecomendLv = 0;
			mLimitTime = 0;
			mKillMonster = 0;
			mDropId = 0;
			mConsumeCardId = 0;
		}
	}

	public class GuardCastleInfoBag
	{
		private object mLocker = null;
		private List<GuardCastleInfo> mList = null;
		private int mCurSelected = 0;
		public GuardCastleInfoBag()
		{
			mLocker = new object();
			mList = new List<GuardCastleInfo>();
		}

		public void Reset()
		{
			lock (mLocker)
			{
				mList.Clear();
			}
		}
		public int CurSelected
		{
			get { return mCurSelected; }
			set { mCurSelected = value; }
		}
		public object Lock
		{
			get { return mLocker; }
		}

		public int ListCount
		{
			get { return mList.Count; }
		}

		/***  添加 ***/
		public void AddInfo(GuardCastleInfo info)
		{
			lock (mLocker)
			{
				GuardCastleInfo gcInfo = mList.Find(p => p.mId == info.mId);
				if (gcInfo == null)
					mList.Add(info);
			}
		}

		/***  更新 ***/
		public void UpdateInfo(GuardCastleInfo info)
		{
			lock (mLocker) 
			{
				GuardCastleInfo gcInfo = mList.Find(p => p.mId == info.mId);
				if (gcInfo != null)
				{
					gcInfo.mIsOpen = info.mIsOpen;
				}
			}
		}

        /***  获得 ***/
        public GuardCastleInfo GetInfo(int id)
        {
            lock (mLocker)
            {
                GuardCastleInfo ret = null;
                for (int i = 0; i < mList.Count; i++)
                {
                    if (mList[i].mId == id)
                    {
                        ret = mList[i];
                        break;
                    }
                }
                return ret;
            }
        }

		/***  获得全部 ***/
		public List<GuardCastleInfo> DataList
		{
			get { return mList; }
		}

		/** 排序 **/
		public void SortList()
		{
			lock (mLocker)
			{
				mList.Sort((left, right) =>
					{
						if (left.mId > right.mId)
							return 1;
						else return -1;
					});
			}
		}
	} 
}
