﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Shark
{
	public class FriendUnit
	{
		public string NickName;
		public ulong Guid;
		public int PlayerId;
		public int Status;//在线状态，不存储
	}
	public class FriendData
	{
		public const int C_MaxCount = 50;
		public object Lock = new object();
		private List<FriendUnit> m_friends = new List<FriendUnit>();
		public FriendUnit GetFriendByGuid(ulong guid)
		{
			return m_friends.Find(p => p.Guid == guid);
		}
		public void AddFriend(FriendUnit friend)
		{
			if (friend == null)
				return;
			if (GetFriendByGuid(friend.Guid) != null)
				return;
			if (m_friends.Count >= C_MaxCount)
				return;
			lock(Lock)
			{
				m_friends.Add(friend);
			}
		}
		public void DeleteFriend(ulong Guid)
		{
			FriendUnit result = GetFriendByGuid(Guid);
			if (result == null)
				return;
			lock (Lock)
			{
				m_friends.Remove(result);
			}
		}
		public List<FriendUnit> GetList()
		{
			return m_friends;
		}
		public void Clear()
		{
			m_friends.Clear();
		}
		public void SortByStatus()
		{
			m_friends.Sort((a, b) => 
				{ 
					if (a.Status < b.Status) 
						return 1; 
					else if (a.Status == b.Status) 
						return 0; 
					else 
						return -1; 
				});
		}
	}
}
