﻿using System.Collections.Generic;

namespace Shark
{
	public class CommonItemBag
	{
		private object mLocker = null;
		private List<CommonItem> mList = null;

		public int Count
		{
			get { return mList.Count; }
		}
		public object Lock
		{
			get { return mLocker;}
		}

		public List<CommonItem> DataList
		{
			get { return mList; }
		}

		public CommonItemBag()
		{
			mLocker = new object();
			mList = new List<CommonItem>();

		}

        public CommonItem GetItem(int dataId)
        {
            lock (mLocker)
            {
                CommonItem result = null;
                for (int i = 0; i < mList.Count; i++)
                {
                    if (mList[i].mDataId == dataId)
                    {
                        result = mList[i];
                        break;
                    }
                }

                return result;
            }
        }

        private CommonItem GetItemUnlock(int dataId)
        {
            CommonItem result = null;
            for (int i = 0; i < mList.Count; i++)
            {
                if (mList[i].mDataId == dataId)
                {
                    result = mList[i];
                    break;
                }
            }
            return result;
        }

		public void AddItem(CommonItem item)
		{
			AddItem(item.mDataId, item.mNumber);
		}

		public void AddItem(int dataId, int num)
		{
			lock(mLocker)
			{
				CommonItem i = GetItemUnlock(dataId);
				if (i == null)
				{
					i = new CommonItem();
					i.mDataId = dataId;
					i.mNumber = num;
					mList.Add(i);
				}
				else
				{
					i.mNumber += num;
				}
			}
		}

		public void DeleteItem(int dataId, int num)
		{
			lock(mLocker)
			{
				CommonItem i = GetItemUnlock(dataId);
				i.mNumber -= num;
				if (i.mNumber <= 0)
				{
					mList.Remove(i);
				}
			}
		}

		public void DeleteItem(CommonItem item, int num)
		{
			DeleteItem(item.mDataId, num);
		}

		public void Reset()
		{
			lock (mLocker)
			{
				mList.Clear();
			}
		}



	}
}
