﻿using System.Runtime.InteropServices;
namespace Shark
{
    [StructLayout(LayoutKind.Explicit, Size = 8)]
    public struct Guid64
    {
        [FieldOffset(0)]
        public long m_lGuid;

        [FieldOffset(0)]
        public int m_Serial;                   //序列号
        [FieldOffset(4)]
        public byte m_Carry;                   //进位 m_serial到达上限就加1
        [FieldOffset(5)]
        public byte m_Type;                    //ServiceType
        [FieldOffset(6)]
        public short m_nWorldId;               //世界号

        public override bool Equals(object obj)
        {
            if(obj is Guid64)
            {
                return this.Equals((Guid64)obj);
            }
            return false;
        }

        public void Init(int serial, byte type, short worldId)
        {
            m_nWorldId = worldId;
            m_Serial = serial;
            m_Type = type;
        }
        public bool Equals(Guid64 guid)
        {
            return m_lGuid == guid.m_lGuid;
        }
        public override int GetHashCode()
        {
            return m_lGuid.GetHashCode();
        }
        public bool IsValid()
        {
            return m_lGuid != GameDefineCom.Invalid_User_Id;
        }
        public static bool operator ==(Guid64 guid1, Guid64 guid2) { return guid1.m_lGuid == guid2.m_lGuid; }
        public static bool operator !=(Guid64 guid1, Guid64 guid2) { return guid1.m_lGuid != guid2.m_lGuid; }
    }
}
