﻿namespace Shark
{
    public class GameDefinePvp
    {
        public const bool PvpLog = false; // Pvp日志开关
        public const int TopPlayerNum = 50; // 排行榜上显示的最多玩家数量
        public const int WinningStreakNum = 50; // 连胜榜上显示的最多信息条数
        public const int WinningStreakMin = 5; // 连胜榜上显示的最小连胜场数
        public const int WinningStreakMax = 10; // 连胜榜上显示的最大连胜场数
        public const int OriginalMatchScore = 1000; // 匹配分初始值
        public const int MaxMatchScore = 1600; // 匹配分最大值
        public const int MinMatchScore = 600; // 匹配分最小值
        public const int PvpNpcSceneClassId = 10; // PvpNpc所在的场景ID
        public const int PvpOneVOneNpcId = 10101; // 1v1Npc
        public const int PvpThreeVThreeNpcId = 10102; // 3v3Npc
        public const int PvpFiveVFiveNpcId = 10103; // 5v5Npc

        public const int PvpOneVOneScriptId = 101003; // 脚本号
        public const int PvpThreeVThreeScriptId = 101004;
        public const int PvpFiveVFiveScriptId = 101005;
        public const eBigLevel LeastRealm = eBigLevel.YUAN_FU; //  参加活动所需最小境界

        public const int PvpOneVOneCopySceneId = 50; // 副本ID
        public const int PvpThreeVThreeCopySceneId = 51;
        public const int PvpFiveVFiveCopySceneId = 52;
        public const int PvpOneVRobotCopySceneId = 53;
        public const int PvpThreeVRobotCopySceneId = 54;
        public const int PvpFiveVRobotCopySceneId = 55;

        public const int PvpOneVOneSceneId = 53; // 场景ID
        public const int PvpThreeVThreeSceneId = 54; 
        public const int PvpFiveVFiveSceneId = 55;

        public const int PvpOneVOneActicityId = 8; // ActivityBaseId
        public const int PvpOneVOneActicityId2 = 10;
        public const int PvpOneVOneActicityId3 = 12;
        public const int PvpThreeVThreeActicityId = 13;
        public const int PvpFiveVFiveActicityId = 14;

        public const int PvpOneVOneMailId = 301; // MailId
        public const int PvpThreeVThreeMailId = 311;
        public const int PvpFiveVFiveMailId = 321;

        public const int PvpPunishTime = 60; // 提前退出比赛的惩罚时间（秒）

        public const int LadderIdTopTen = 35;
        public const int LadderIdTopFifty = 34;
        public const int LadderIdXinRuiTopThree = 33;
        public const int LadderIdTopHundred = 32;
        public const int LadderIdXinRuiTopTwenty = 31;
    }

    public enum EPvpType
    {
        Invalid = 0,
        OneVOne,
        ThreeVThree,
        FiveVFive,
    }

    public enum EPvpGiftType
    {
        FirstWin = 0,
        FiveBattles,
        FiveWin,
        TenWin,
        FiveWinningStreak,
        TenWinningStreak,
        ShutDown,
        RankOne,
        RankTwo,
        RankThree,
        TopTen,
    }

    public enum EPvpGiftState
    {
        None = 0,
        Exist = 1,
        Already = 2,
    }
    public enum EPvpMatchResultType
    {
        Success = 0,
        NoOpenTime = 1,
        NoFindPlayer = 2,
    }
    public enum EpkModelType
    {
        Type_Peace = 0,             //和平(不可攻击任何玩家)
        Type_Force = 4,             //强制(不可攻击队友和盟友)
        Type_All = 5,                 //全体(不可攻击队友)
        Type_GuildBattle = 8,   //势力战

        Type_TeamPK = 13,       //队伍
        Type_GuildPk = 14,      //公会
        Type_CrazyPk = 15,      //杀戮
        Type_ShenYuCamp = 16,   //神域阵营
    }

    public enum EPvpFailureReason
    {
        Position = 1, // 距离npc过远
        Realm, // 境界不足
    }

    public enum ELadderOptType
    {
        Type_Match = 0, //匹配
        Type_GotoScene = 1,
        Type_GetLadderData = 2,
        Type_ShowRoundEffect = 3,
        Type_SyncHp = 4,
        Type_StartCountTIme = 5,
        Type_Start30CountTime = 6,
        Type_Close30CountTime = 7,
        Type_PassLadderToWin = 8,
        Type_AfterLadderEnd = 9,
        Type_Error = 10,
    }

    public enum EArenaOptType
    {
        GetData = 0,
        SyncHp = 1,
        StartCountTime = 2,
    }
}
