﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Shark
{
    public class GameDefineMission
    {
        public const int MaxMissionDataId = 4096;
        public const int MaxMissionFlagId = 4096;
        public const int MaxMissionId = 1024 * 4;
        public const int MaxAchievementId = 1024;
        public const int MAX_USER_MISSION_COUNT = 40;
        public const int MAX_USER_MISSION_COUNT_CLIENT = 20;
        // public const int MAX_USER_MISSION_FALG_LEN = 32;
        public const int MAX_MISSION_PARAM_COUNT = 17;

        public const int ParamRegExpire = 5;
        public const int ParamRegFailedFlag = 6;
        public const int ParamSetFailedFlag = 7;

        public const int TeamRoundMissionActivity = 32;
        public const int TeamRoundMissionTeamPlatformId = 500;
        public const int TeamRoundMissionItemId = 105100010;

        public const int FlyShoeItemId = 102500011;
        public const int FreeFlyShoeVipLvl = 1;
    }



    public enum EMissionDataId : int
    {
        EMD_Invalid = -1,
        EMD_MissionRoundStart = 0,
        EMD_MissionRoundEnd = 50,

        EMD_CurTowerId = 51,      //爬塔每日挑战次数
        EMD_TianMengNormolAward = 52,//天梦林副本侠义奖励
        EMD_TianMengLuckBoss = 53,//天梦林隐藏boss掉落次数
        EMD_Dark_ForestTime = 54,   //   黑暗森林侠义值获取次数
        EMD_Dark_ForestLuckBoss = 55,  //   黑暗森林隐藏BOSS掉落次数
        EMD_Dark_ForestBoss = 56,  //   黑暗森林BOSS掉落次数
        EMD_Low_Stars_ActivitiesBoss = 57,   //  斗战台低等级Boss掉落次数
        EMD_Low_Stars_ActivitiesCh = 58,    //   斗战台低等级侠义值获取次数
        EMD_High_Stars_ActivitiesBoss = 59,   //  斗战台高等级模式Boss掉落次数 
        EMD_Third_Ring = 60,     // 三环活动的一环奖励获取次数
        EMD_JunLinYanBoss = 61,

        //请求临时符状态
        EMD_IsRequestTemporartIncantation = 62,
        EMD_IsUseTemporartIncantation = 63,
        //请求临时符日期与次数
        EMD_TemporartIncantationDays = 64,
        EMD_AwardGuildRobber = 65, //  帮派强盗奖励次数
        EMD_Third_RingWeek = 66,  //  三环周第一环
        EMD_LastEnterGuildBattleSceneTime = 67,
        EMD_GuDiZhiChengNum = 68,
        //各种日常上限
        EMD_DailyHelpLimit = 70,
        EMD_SanHuan1Ch = 71,            //  三环侠义值枚举
        EMD_SanHuan2Ch = 72,
        EMD_SanHuan3Ch = 73,
        EMD_Sanhuan1WeekCh = 74,
        EMD_Sanhuan2WeekCh = 75,
        EMD_Sanhuan3WeekCh = 76,
        EMD_LastDayCheckDailyFirstLogin = 77,
        EMD_WorldBossCount1 = 78,
        EMD_WorldBossCount2 = 79,
        EMD_WorldBossCount3 = 80,
        EMD_MoXiangYa = 81,
        EMD_LastRechargeDate = 82,	//上次充值日期
        EMD_DailyRechargeMoney = 83,	//每日充值元宝数
        EMD_LastDayCheckDailyFirst = 84,
        EMD_WorldBossCount4 = 85,

        EMD_LastJoinYunYingActivityTime_0 = 86,
        EMD_LastJoinYunYingActivityTime_1 = 87,
        EMD_TreasurePlaceLayer = 88,
        EMD_TreasurePlaceWroldLvl = 89,
        EMD_TreasurePlaceTotalPoint = 90,
        EMD_TreasurePlaceGetState_Layer1 = 91,
        EMD_TreasurePlaceGetState_Layer2 = 92,
        EMD_TreasurePlaceGetState_Layer3 = 93,
        EMD_TreasurePlaceGetState_Layer4 = 94,
        EMD_TreasurePlaceActivityID = 95,

        EMD_PizzleStart = 100,//答题
        EMD_PizzleEnd = 125,

        EMD_GuaJiGameSet = 126,
        EMD_FirstMoBaiTime1 = 127,
        EMD_FirstMoBaiTime2 = 128,
        EMD_FirstMoBaiTime3 = 129,
        //个人古运数
        EMD_VIPInvestCheckTime = 130,
        EMD_VIPInvestLastCheckZhouQiTime = 131,

        //云购购买计数
        EMD_YunGouBuyCount = 132,
        //活跃度系数
        EMD_ActivityValueLvl = 133,
        EMD_EternalTreasureScore = 134, // 永恒宝库的积分数量
        EMD_EternalTreasureEffectTime = 135, // 永恒宝库的当前有效时间
        EMD_EternalTreasureReward = 136,    // 永恒宝库奖励记录领取状态
        EMD_EternalTreasureLevel = 137, // 刷新永恒宝库奖励时记录的奖励等级

        EMD_SLBossBoxCount = 138, // 试练boss宝箱掉落次数统计
        EMD_MiJingBossDoubleDrop = 139, //秘境boss双倍掉落
        /*※※※ 140~159之间不允许采用，此间断为使用增加副本次数预留！！！特此声明！！！ ※※※*/
        EMD_AddCopySceneJoinCount_Start = 140,
        EMD_AddCopySceneJoinCount_End = 159,
        EMD_AddVIPExpTime = 160,
        //161-190之间为VIP找回次数记录
        EMD_FindReward_VIP_Start = 161,
        EMD_FindReward_VIP_End = 190,

        EMD_ActivityOne = 191, //  四合一活动一领取状态   0为未充值  1为已充值 2为已领取
        EMD_ActivityThree = 192, // 四合一活动三领取状态   按位存储

        EMD_ActivityFour1 = 193, // 四合一活动4记录是否领取第1名
        EMD_ActivityFour2 = 193, // 四合一活动4记录是否领取第2名
        EMD_ActivityFour3 = 193, // 四合一活动4记录是否领取第3名

        EMD_ActivityThreeScore = 194, // 四合一活动三积分数量

        EMD_ActivityOneStartIndex = 195, //四合一活动1开启索引记录
        EMD_ActivityTwoStartIndex = 196, //四合一活动2开启索引记录
        EMD_ActivityThreeStartIndex = 197, //四合一活动3开启索引记录
        EMD_ActivityFourStartIndex = 198, //四合一活动4开启索引记录
        EMD_ActivityRankvalue = 199,   // 充值活动计数
        //活动活跃度相关
        EMD_ActivityTime = 200,             //活跃度重置时间判断用

        /*※※※ 201~250之间不允许采用，此间断为活动参加次数预留！！！特此声明！！！ ※※※*/
        EMD_Activity_JoinCountStart = 201,     //黑暗森林通关次数
        EMD_Activity_JoinCountEnd = 250,

        /*※※※ 251~300之间不允许采用，此间断为计算活跃度次数预留！！！特此声明！！！ ※※※*/
        EMD_ActivityNum_Start = 251,
        EMD_ActivityNum_End = 300,


        EMD_ActivityGift_1 = 301,           //活跃度奖励监测
        EMD_ActivityGift_2 = 302,
        EMD_ActivityGift_3 = 303,
        EMD_ActivityGift_4 = 304,
        EMD_ActivityGift_5 = 305,

        EMD_DailyVitatly = 306,
        EMD_YueKaStartTime = 307,
        EMD_CardBoxTime = 308,   // 卡牌副本宝箱奖励次数

        /*※※※ 310~329之间不允许采用，此间断为增加副本使用卷使用次数预留！！！特此声明！！！ ※※※*/
        EMD_AddCopySceneCount_Start = 310,
        EMD_AddLadderCount = 311,
        EME_AddCopySceneCount_End = 329,
        //单冲
        EMD_OneRechargeActivity_Start = 330,
        EMD_OneRechargeActivity_End = 350,
        //单日消费
        EMD_OneConsumeActivityCount = 351,
        EMD_OneConsumeActivityStage = 352,
        //累计充值
        EMD_TotalRechargeActivityCount = 353,
        EMD_TotalRechargeActivityStage = 354,
        //累计消费
        EMD_TotalConsumeActivityCount = 355,
        EMD_TotalConsumeActivityStage = 356,
        EMD_OneRechargeRewardId = 357,
        EMD_OneConsumeRewardId = 358,
        EMD_TotalRechargeRewardId = 359,
        EMD_TotalConsumeRewardId = 360,
        EMD_OneRechargeActivityId = 361,
        EMD_OneConsumeActivityId = 362,
        EMD_TotalRechargeActivityId = 363,
        EMD_TotalConsumeActivityId = 364,
        EMD_TianXingBaoGeRewardId = 365,
        EMD_TianXingBaoGeActivityId = 366,
        EMD_TianXingBaoGeCount = 367,
        EMD_XianShiQiangGouActivityId = 368,
        EMD_XianShiQiangGouStart = 369,
        EMD_XianShiQiangGouEnd = 372,
        EMD_XianShiQiangGouRewardId = 373,

        EMD_SLBossPerfect1 = 374,
        EMD_SLBossPerfect2 = 375,
        EMD_SLBossPerfect3 = 376,
        EMD_SLBossPerfect4 = 377,
        EMD_SLBossPerfect5 = 378,
        EMD_SLBossPerfect6 = 379,

        EMD_LasFleeTime = 380,

        EMD_ShopRefreshDaily = 381,
        EMD_ShopRefreshWeekly = 382,
        EMD_ShopRefreshHour_12_18 = 383,
        EMD_ShopRefreshCard = 384,
        EMD_ShopRefreshMore = 385,
        EMD_ShopRefresh6 = 386,
        EMD_ShopRefresh7 = 387,
        EMD_ShopRefresh8 = 388,
        EMD_ShopRefresh9 = 389,
        EMD_ShopRefresh10 = 390,

        EMD_ShopRefreshDailyCount = 391,
        EMD_ShopRefreshWeeklyCount = 392,
        EMD_ShopRefreshHour_12_18Count = 393,
        EMD_ShopRefreshCardCount = 394,
        EMD_ShopRefreshMoreCount = 395,

        EMD_ShopRefreshEnd = 399,
        EMD_FourActivityStart = 400,   // 四合一活动的任务记录
        EMD_FourActivityEnd = 429,
        EMD_ActivitySignInWorldLvl = 430,   //  四合一活动开启的时候的世界等级记录  430-442
        EMD_ActivityFireWorkWorldLvl = 431,
        EMD_ActivityAllPeopleWorldLvl = 432,
        EMD_ActivityRankWorldLvl = 433,
        EMD_MergeXianShiBaoXiangLvl=434,
        EMD_FourActivity12 = 442,

        EMD_JuHunCopySceneHuangJingBoss = 443, //是否召唤黄金Boss
        EMD_JuHunCopySceneTownTotalNum = 444, // 聚魂副本创建塔的总数
        EMD_JuHunCopySceneDingShenNum = 445,  // 定身Buff叠加数
        EMD_JuHunCopySceneTownTypeNum2 = 446,  // 种类2的塔创建总数
        EMD_JuHunCopySceneTownTypeNum3 = 447,  // 种类3的塔创建总数
        EMD_JuHunCopySceneScore = 448,  //  聚魂副本积分
        EMD_JuHunCopySceneIsAuto = 449,  // 聚魂副本是否正在战斗
        EMD_JuHunCopySceneIsPass = 450,  // 聚魂副本是通关过

        EMD_JuHunTowerType = 451, // 聚魂副本塔的创建记录
        EMD_GuildBlessTime = 455, // 每日的势力祈福
        EMD_FreeOCTime = 456, //免费挂机时间
        EMD_ServerBoxTimes = 457,
        EMD_ServerBoxTime = 458,
        EMD_TodayIsSign = 459, //今天是否签到
        EMD_RewardTime = 460,//上次领取签到奖励的时间
        EMD_LastAddPrizeDrawNum = 461,//上次因为活跃度添加的抽奖次数时间（一天不能加两次）
        EMD_LastSevenGiftsTime = 462,//用于判断今日是否得到七日礼包
        EMD_GradeReward = 463,//等级奖励按位存储
        EMD_OnlineRewardNum = 464,//在线时长奖励(领到第几个)
        EMD_OnlineRewardTime = 465,//在线时长奖励(可以领取的时间)
        EMD_RetroactiveTimes = 466,//剩余补签次数
        EMD_PrizeDrawNum = 467,//剩余抽奖次数
        EMD_PrizeDrawSeat = 468,//上次抽奖位置
        EMD_SevenGifts = 469,//七日礼包
        EMD_TotalRechargeMoney = 470,//累计充值金额
        EMD_IsFirstReward = 471,//是否领取首冲
        EMD_TotalConsumeMoney = 472,//累计消费金额
        EMD_RechargeReward = 473,//充值奖励
        EMD_ConsumeReward = 474,//消费奖励
        EMD_TodayIsClickFirstPay = 475, //首充特效
        EMD_Tarrace = 476,
        EMD_NirvanaCount = 477,//涅槃复活次数
        EMD_AllSignTimes = 478,//累计签到次数
        /*※※※ 479~511之间不允许采用，此间断为道具每日使用上限预留！！！特此声明！！！ ※※※*/
        EMD_ItemUseLimitStart = 479,
        EMD_ItemUseLimitEnd = 511,

        /*※※※ 512~561之间不允许采用，此间断为基础奖励记录ID 预留！！！特此声明！！！ ※※※*/
        EMD_CSBonusMDID_0 = 512,
        EMD_CSBonusMDID_49 = 561,

        /*※※※ 562~611之间不允许采用，此间断为永恒宝库进度记录ID 预留！！！特此声明！！！ -1表示已领取 ※※※*/
        EMD_Eternal_TreasureMDID_0 = 562,
        EMD_Eternal_TreasureMDID_49 = 611,

        /*※※※ 612~650之间不允许采用，此间断精灵盛殿物品商店兑换预留！！！特此声明！！！ ※※※*/
        EMD_ActivityItemMDID_0 = 612,
        EMD_ActivityItemMDID_38 = 650,

        EMD_DragonBoatFestivalSignInLvl = 651,   // 端午登录世界等级
        EMD_DragonBoatFestivalMonsterLvl = 652, // 端午节整点怪世界等级
        EMD_DragonBoatFestivalExchangeLvl = 653, // 端午兑换世界等级



        EMD_DragonBoatFestivalSignInDay = 654, // 端午累计登录天数记载     
        EMD_DragonBoatFestivalSignInAward = 655,  // 端午累计天数奖励领取情况
        EMD_YingYongBao_DayGift = 656,//应用宝每日奖励

        EMD_Oppo_DailyLaunchGift = 657,
        EMD_Oppo_WeekGift_Time = 658,
        EMD_Oppo_WeekGift_Stage = 659,
        EMD_Oppo_VIPGift = 660,



        EMD_CSIsPvpEnroll = 662, // 是否已报名擂台赛
        EMD_CSIsDinnerEnroll = 663, // 是否已报名势力晚宴
        EMD_CSIsFormationEnroll = 664, // 是否已报名守护朱雀
        EMD_FormationBoxPickNum = 665, // 守护朱雀宝箱采集数量
        EMD_GuildDinnerMissionExpRatio = 666, // 势力晚宴任务经验奖励加成系数
        EMD_GuildDinnerMissionMoneyRatio = 667, // 势力晚宴任务金钱奖励加成系数
        EMD_GuildDinnerDonate = 668, // 势力晚宴捐献食物数量

        EMD_CopySceneReliveNum = 669,
        EMD_LastGuildId = 670, // 上一家势力ID
        EMD_LastWeekContribution = 671, // 上周势力贡献
        EMD_ThisWeekContribution = 672, // 本周势力贡献
        EMD_TotalContribution = 673, // 历史贡献
        EMD_IsPvpReward = 674, // 是否可以获取擂台赛奖励
        EMD_PvpCamp = 675, // 擂台赛阵营

        EMD_FirstTowerReward_2 = 676,//问天路首通奖励 是否领取 
        EMD_FirstTowerReward_3 = 677,
        EMD_FirstTowerReward_4 = 678,
        EMD_FirstTowerReward_5 = 679,
        EMD_FirstTowerReward_6 = 680,
        EMD_FirstTowerReward_7 = 681,
        EMD_FirstTowerReward_8 = 682,
        EMD_FirstTowerReward_9 = 683,
        EMD_FirstTowerReward_10 = 684,

        EMD_GroupPointTimes_Start = 685,//采集点采集次数计数
        EMD_GroupPointTimes_End = 748,
        EMD_FindOperationRewardDay = 749,//刷新找回奖励时候的等级
        EMD_FindOperationRewardInfo = 750,
        EMD_FindOperationReward_Start = 751,//记录找回奖励的次数和找回奖励的刷新天数
        EMD_FindOperationReward_End = 780,
        EMD_FindTowerRewardTime = 781,

        EMD_DivorceTime = 782,//离婚时间
        EMD_FirstLoginToDay = 783,
        EMD_YingYanTime = 784,//鹰眼参加时间
        EMD_YingYanRecord = 785,//当前关卡，成功次数，七次奖励是否领取，完胜奖励是否领取  
        EMD_YingYanFindCount = 786,//鹰眼找到的个数   
        EMD_EquipXiLianAll = 787,//十个洗练位 每个洗练位的状态
        EMD_EquipXiLian_1 = 788,//每个洗练位，4条洗练属性的锁定状态
        EMD_EquipXiLian_10 = 797,//
        EMD_EquipXiLianTime = 798,//每日免费洗练次数
        EMD_MoNengFeiXuId = 799,
        /*※※※ 800~849之间不允许采用，此间断为功能预告 预留！！！特此声明！！！ ※※※*/
        EMD_FuncPerpare_Start = 800,
        EMD_FuncPerpare_End = 849,

        /*※※※ 850~879之间不允许采用，此间断为购买副本次数 预留！！！特此声明！！！ ※※※*/
        EMD_CopySceneBuyCount_Start = 850,
        EMD_CopySceneBuyCount_End = 879,

        /*※※※ 880~919之间不允许采用，此间断为购买副本冷却 预留！！！特此声明！！！ ※※※*/
        EMD_CopySceneCD_Start = 880,
        EMD_CopySceneCD_End = 919,

        /*※※※ 920~949之间不允许采用，此间断为购买副本扫荡 预留！！！特此声明！！！ ※※※*/
        EMD_CopySceneMopUp_Start = 920,
        EMD_CopySceneMopUp_End = 949,

        /*※※※ 950~979之间不允许采用，此间断为副本参加次数 预留！！！特此声明！！！ ※※※*/
        EMD_CopySceneJoinCount_Start = 950,
        EMD_CopySceneJoinCount_End = 979,
        EMD_CreateTime = 980,
        EMD_FirstRechargeTime = 981,
        EMD_GetWishAwaryTimes1 = 983,
        EMD_GetWishAwaryTimes2 = 984,
        EMD_BindMoneyEncouragement = 985,
        EMD_YuanBaoEncouragement = 986,
        EMD_BossCopySceneDropTime = 987,   // 试练boss掉落次数

        EMD_FireWorksCount = 988, // 记录玩家使用的烟花的数量
        EMD_AcvitityRefreshTime = 989, // 新的刷新活动时间

        /*998~1005之间是神器认主*/
        EMD_ShenQiRenZhu_Start = 998,
        EMD_ShenQiRenZhu_End = 1005,
        EMD_SignTatolReward = 1006,

        EMD_BrawlScore = 1007, // 乱斗副本获得积分
        EMD_BrawlStage = 1008, // 乱斗副本已完成阶段
        EMD_BrawlWinningStreak = 1009, // 乱斗副本当前连胜
        EMD_BrawlRewardState = 1010, // 乱斗副本奖励状态
        EMD_MoDuoBonus = 1011, // 魔多斗兽场基础奖励
        EMD_OpenCollectActivityTime = 1012, // 开始集字活动的日期
        EMD_VipGuildLuckyPacket = 1013, // 每天发放的Vip红包金额
        EMD_BrawlMaxWS = 1014, // 乱斗副本最多连杀
        EMD_PvpMaxWS = 1015, // 天骄战最多连胜
        EMD_KaiFuPaiHang = 1016,//开服排行
        EMD_YuanBaoInvestCostType = 1017,//元宝投资类型
        EMD_YuanBaoInvestRecord = 1018,//元宝投资领取记录 
        EMD_RechargeBox = 1019, // 充值宝箱购买记录
        EMD_ActiveShenTongId = 1020,
        EMD_ChangeJob4Stage = 1021,//4转状态
        EMD_LadderPvpScore = 1022, // 跨服天梯积分
        EMD_LadderServerPvpWS = 1023, // 跨服天梯连胜
        EMD_LingGongCSId = 1024, //天符战界当前攻击系列通关Id
        EMD_LingYuCSId = 1025, //天符战界当前防御系列通关Id

        EMD_FreeChallengeFuLingCS = 1026, // 天符战界是否能免费挑战下一关卡
        EMD_RequestJuLingCsType = 1027, // 上一次挑战天符战界的种类
        EMD_TianDaoShengYuanCopySceneId = 1028, //天道圣院副本Id
        EMD_FesMonsterWorldLvl = 1029,
        EMD_FesShopWorldLvl = 1030,
        /*※※※ 1031~1041之间不允许采用，此间断为九天深藏 预留！！！特此声明！！！ ※※※*/
        EMD_TreasurePlace_Start = 1031,
        EMD_TreasurePlace_End = 1041,


        EMD_BenYuanDecomposeCount = 1042,

        //记忆挑战
        EMD_MemoryChallengeFindCount = 1043, //找到的总数
        EMD_MemoryChallengeFingerCount_Round1 = 1044, //第一关点击次数
        EMD_MemoryChallengeFingerCount_Round2 = 1045, //第二关点击次数
        EMD_MemoryChallengeFingerCount_Round3 = 1046, //第三关点击次数
        EMD_MemoryChallengeRoundCount = 1047,     //记忆挑战关卡
        EMD_MemoryChallengeJoinRewardtState = 1048,   //记忆挑战参与领奖
        EMD_MemoryChallengeRoundRewardState = 1049,   //记忆挑战关数领奖
        EMD_MemoryChallengeTime = 1050,  //记忆挑战时间戳

        EMD_LastChallengeAttJuLingId = 1051, // 记录上一次挑战聚灵副本攻击的塔ID
        EMD_LastChallengeDefJuLingId = 1052, // 距离上一次挑战聚灵副本防守的塔ID

        EMD_MemoryChallengeEveryRoundFindCount = 1053, //记忆挑战每局找到次数
        EMD_YongHengBaoKuWeekIndex = 1054, // 记录永恒宝库开启的时候的周
        EMD_DailySignTimes = 1055,

        EMD_GuildZhaoJiCount = 1065, //势力召集次数
        EMD_WorldBossCount5 = 1066,
        EMD_PiaoMiaoShengDianCount = 1067,

        EMD_DailyRecharge = 1068,   // 每日充值的具体值
        EMD_DailyRechargeCount = 1069,// 活动期间每日充值达到300元宝天数
        EMD_RecordDailyRecharge = 1070, // 记录每日充值的领取情况
        EMD_RecordDailyRechargeCount = 1071, // 记录每日充值达到300元宝天数的领取情况
        EMD_RecordDailyRechargeWorldLvl = 1072, // 记录每日充值人物等级

        EMD_SLBossPerfect7 = 1073,
        EMD_SLBossPerfect8 = 1074,
        EMD_SLBossPerfect9 = 1075,
        EMD_SLBossPerfect10 = 1076,
        EMD_SLBossPerfect11 = 1077,
        EMD_SLBossPerfect12 = 1078,

        EMD_JingXiShiKeTime = 1079,

        EMD_6YuanDailyBuyCount = 1080,  //6块钱每日购买次数，格式:2018071700
        EMD_30YuanDailyBuyCount = 1081, //30块钱每日购买次数，格式:2018071700

        EMD_MergeSignInDay = 1082, // 合服活动累计登录天数记载     
        EMD_MergeSignInAward = 1083,  // 合服活动累计天数奖励领取情况
        EMD_MergeSignInLvl = 1084,   // 合服活动登录世界等级

        //EMD_MergeSignInIndex = 1085,   // 合服活动对应的奖励套
        EMD_MergeRechargeWorldLvl = 1086,   // 合服充值活动世界等级

        EMD_MergeActivityRecharge = 1087, //  合服充值活动一领取状态   0为未充值  1为已充值 2为已领取,
        EMD_MergeRechargeIndex = 1088,  // 合服充值活动对应套数

        EMD_ShenWangLiLianStage = 1089,//神王试炼奖励领取状态
        EMD_ConsumeAuctionDaily = 1090,     //拍卖行每日消费
        EMD_MarryRewardTime = 1091,
        EMD_YuanBaoInvestPlusCostType = 1092,//元宝投资巅峰版类型
        EMD_YuanBaoInvestPlusRecord = 1093,//元宝投资巅峰版领取记录 
        EMD_YiLuoZhanJing = 1094,

        EMD_FesAllPeopleWorldLvl = 1095, // 节日全民狂欢世界等级


        /*※※※ 1096~1130之间不允许采用，此间断为功能节日全民狂欢进度记录 预留！！！特此声明！！！ ※※※*/
        EMD_FestivalCarnivalRewardStart = 1096, // 节日全民狂欢进度记录开始
        EMD_FestivalCarnivalRewardEnd = 1130, // 节日全民狂欢进度记录结束

        EMD_FestivalCarnivalMissionIndex = 1131, // 节日狂欢对应积分领取标志位
        EMD_FestivalCarnivalScore = 1132, // 节日狂欢对应积分数量
        EMD_FestivalCarnivalActId = 1133, // 记录当前的进行的狂欢活动的Id
        EMD_FestivalRandomShopActId = 1134, // 记录当前的进行的随机商店的Id
        EMD_FestivalRandomShopIndex = 1135, // 记录商店对应的刷新次数
        EMD_RandomShopWorldLvl = 1136, // 随机商店存储世界等级
        EMD_RandomShopRefreshIndex = 1137, // 随机商店刷新次数

        EMD_TuPoBonus = 1138, // 突破副本的基础奖励

        /*※※※ 1139~1159，此间断为九天深藏 预留！！！特此声明！！！ ※※※*/
        EMD_TreasurePlace_Start2 = 1139,
        EMD_TreasurePlace_End2 = 1159,

        /*※※※ 1160~1209之间不允许采用，此间断为活动参加次数预留！！！特此声明！！！ ※※※*/
        EMD_Activity_JoinCountStart2 = 1160,     //黑暗森林通关次数
        EMD_Activity_JoinCountEnd2 = 1209,

        /*※※※ 1210~1259之间不允许采用，此间断为计算活跃度次数预留！！！特此声明！！！ ※※※*/
        EMD_ActivityNum_Start2 = 1210,
        EMD_ActivityNum_End2 = 1259,
        EMD_XingHunLevelUpCount = 1260,
        EMD_XingHunLevelUpBuyCount = 1261,
        EMD_ChangeJob5Stage = 1262,
        EMD_ChiJiBestRankId = 1263,
        EMD_GetWishAwaryTimes3 = 1264,
        EMD_WorldBossCount6 = 1265,
        EMD_WorldBossCount7 = 1266,
        EMD_Pillar_State = 1267,//万象天域特殊特效任务id
        EMD_RealmSectionID = 1268,
        EMD_AxeEffect = 1269,//万象天域雷击特效任务id
        EMD_MergeSignInData= 1271,

        EMD_ShenShiKuangMai = 1273,

        //rmb禮包(1274-1310 RMB.xlsx中使用) 
        EMD_RMB_START = 1274,
        EMD_RMB_END = 1310,

        EMD_Level2PwdQuestionId = 1311,
        /*※※※ 1401~1449之间不允许采用，此间断春节转盘商店兑换预留！！！特此声明！！！ ※※※*/
        EMD_LuckyRollItemMDID_0 = 1401,
        EMD_LuckyRollItemMDID_End = 1449,
        EMD_LuckyRollShopTAId = 1450,
        EMD_LuckyRollShopScore = 1451, // 转盘积分对应点
        EMD_LuckyRollShopMissionRecord = 1452, // 幸运星盘-星力兑换记录二进制
        EMD_LuckyRollShopMissionValue = 1453, // 幸运星盘-星力值（抽奖次数）
        EMD_FreeLuckyCoinRecord = 1454, // 幸运星盘-任务奖励领取记录二进制
        EMD_SpringFestivalShopWorldLvl = 1455, // 春节惊喜商店世界等级
        EMD_KaiMenLiShiValue = 1456,
        EMD_StarSkyMoneyTreeCount = 1457,
        EMD_KaiMenLiShiLogin = 1458,
        

        EMD_GuildDeclaration = 1656,
        EMD_VipDailyGift = 1657,
        EMD_TotalOnlineSecond = 1658,
        EMD_BOSSInvestType = 1659,
        EMD_BOSSInvestRecord = 1660,

        EMD_GetWishCount1 = 1670,//免费祈福 金币 记录次数
        EMD_GetWishCount2 = 1671,//免费祈福 专精 记录次数

        EMD_GetWishAddition1 = 1672,//祈福 金币 记录总次数
        EMD_GetWishAddition2 = 1673,//祈福 经验 记录总次数

        EMD_ExpMonsterNum = 1674,//剧情本用 给经验怪物数量

        EMD_DragonBoatFestivalSignInDay2 = 1675, // 端午累计登录天数记载 2    
        EMD_DragonBoatFestivalSignInAward2 = 1676,  // 端午累计天数奖励领取情况 2


        /*※※※ 1677~1715，此间断精灵盛殿物品商店兑换预留！！！特此声明！！！ ※※※*/
        EMD_ActivityItemMDID2_0 = 1677,
        EMD_ActivityItemMDID2_38 = 1715,
        
        //境界任务 
        EMD_CombatUpRewardStart = 1716,
        EMD_CombatUpRewardEnd = 1755,

        EMD_PersonMoXiangYa = 1760,//个人魔像崖

        EMD_FesShopWorldLvl2 = 1761,

        //1762 ~1770  预留
        EMD_StartIndexMD2 = 1762,
        EMD_FesShopWorldLvl3 = 1764,

        EMD_EndIndexMD2 = 1770,
        EMD_OpenFirstPunch = 1771,

        EMD_ShentongSkill = 1772,
        //周一狂欢相关
        //1773 ~ 1790  为周一狂欢的奖励限购数量预留18个位置
        EMD_MondayLuckDrawItemStartIndex = 1773,
        EMD_MondayLuckDrawItemEndIndex = 1790,
        //1791 ~ 1840  为周一狂欢的任务奖励类型预留50个位置
        EMD_MondayLuckDrawMissionStartIndex = 1791,
        EMD_MondayLuckDrawMissionEndIndex = 1840,
        EMD_MondayLuckDrawPosition1 = 1841,//特等奖位置奖励
        EMD_MondayLuckDrawPosition2 = 1842,//一等奖位置奖励1
        EMD_MondayLuckDrawPosition3 = 1843,//一等奖位置奖励2
        EMD_MondayLuckDrawSpecialRewardFlag = 1844,//本周是否抽到过特等奖
        EMD_MondayLuckDrawRefreshTime = 1845,
        EMD_MondayLuckDrawTicketCount = 1846,
        EMD_MondayLuckDrawBaseCount = 1847,
        EMD_MondayLuckDrawTicketCountGet = 1862,// 抽奖卷获取次数判定
        EMD_MondayLuckDrawTicketCountUse = 1864,// 抽奖次数
        EMD_LastDayCheckDailyFirst2 = 1848,
        EMD_DailyFirstLvRewardDataId = 1849,

        EMD_PersonBossFreeCount = 1850,//个人boss免费次数

        EMD_EternalTreasureRewardStart = 1851,//天符宝阁是否领取标识
        EMD_EternalTreasureRewardEnd = 1860,//天符宝阁是否领取标识
        /*※※※ 1863~1962之间不允许采用，此间断为 是否领取boss首杀奖励 预留！！！特此声明！！！ ※※※*/
        EMD_BOSSFirstKillGetReward_Start = 1863,
        EMD_BOSSFirstKillGetReward_End = 1962,

		EMD_FUBENFailRemark = 1963, // 副本失败标识 副本每日失败次数
		EMD_PowerShop = 1964, // 势力商店

        //周一狂欢相关
        //1773 ~ 1790  为周一狂欢的奖励限购数量预留18个位置
        EMD_MondayLuckDrawItemShowNewStartIndex = 1965,
        EMD_MondayLuckDrawItemShowNewEndIndex = 1982,
		EMD_GuildCollectFastTimes = 1983,  // 势力 快速炼气 次数

        /*※※※ 1984~2022，此间断精灵盛殿物品商店兑换预留！！！特此声明！！！ ※※※*/
        EMD_ActivityItemMDID3_0 = 1984,
        EMD_ActivityItemMDID3_38 = 2022,

		EMD_BuyQingYuanTimes = 2023, // 每日购买情缘本次数

		EMD_BuyQingYuanGiftMail = 2024,   // 情缘邮件发送标识
		EMD_PaiMaiHangStatus = 2025,  // 拍卖行使用状态
		EMD_MarryMailStatus = 2026, // 情缘魅力排行榜 邮件发送标识
		EMD_MarryCharmNum = 2027, // 情缘活动期间的魅力
		EMD_SendAskFowerCd = 2028, // 发送索要鲜花间隔
        EMD_LastTianFuAddPointPos = 2029,//天赋点位置
		EMD_ExpFubenTimes = 2030, // 进入无尽深渊次数
		EMD_ArcheanRelicsMark = 2031, // 太古遗迹活动结束 标识
		EMD_MarrySevenMark = 2032,  // 7天奖励发送标识
		EMD_MarryFifTeenMark = 2033, // 15天奖励发送标识
		EMD_EveryDayLoginTime = 2034, // 每天登陆时间
        EMD_KillFreeBossStart=2035,
        EMD_KillFreeBossEnd = 2055,

        EMD_RealmFinishNum = 2056,
        EMD_HomeBossShopItem = 2057,   //shoptype表中用到
        //星语心愿位置预留56个位置
        EMD_StarWishItemStart = 2058,
        EMD_StarWishItemEnd = 2113,
        EMD_StarWishEndMark = 2114, // 星语心愿活动结束 标识

        EMD_DailyRechargeActBaseId = 2115,//累计充值活动记录活动ID 当前参加了活动 在登录时下一期这个活动开这
        EMD_HomeWorldBossCount = 2116,//秘境boss每日击杀数

        EMD_FreeBossCanJoinCount = 2117,//洞天福地boss可参加次数
        EMD_FreeBossHaveAddCount=2118,  //洞天福地boss已增加次数
        EMD_BuyGiftBoxForPartnerMark = 2119, // 购买情缘礼盒标识

        EMD_GreetingCardCount = 2120, //拥有的贺卡数量
        EMD_DailySendGreetingCardCount = 2121,//每日发送的贺卡数量 
        EMD_DailyGreetingCardMissionId = 2122,//记录领取节日任务id

        EMD_ChickenFightEndMark = 2123, // 小鸡大作战结束标识
        EMD_MarryActivityType = 2124, // 情缘活动开启类型 
        EMD_LastRightGuildQuestion = 2125, //晚宴答题最后一道正确的
        EMD_MarryThirtyMark = 2126, // 30天奖励发送标识

        EMD_MergeTotalRechargeRewardId = 2127, // 合服累充标记位  表 RechargeAndConsumeBase 引用
        EMD_MergeTotalRechargeCount = 2128, // 合服累充标记位 
        EMD_MergeTotalRechargeStage = 2129, // 合服累充标记位

        EMD_MergeTouZiStartTime=2130,   //合服投资开启时间
        EMD_MergeTouZiStage = 2131,   //合服投资领取记录
        EMD_MergeTouZiType = 2132,   //合服投资类型

        EMD_MergeXianShiBaoXiangIndex = 2133, //
        EMD_MergeTouZiIndex = 2134, //
        //EMD_MergeTotalRecharge = 2135, //

        EMD_MergeBaoXiangStage = 2136,   //合服限时宝箱领取状态
        EMD_ChickenFightMailMark = 2137,   // 小鸡大作战邮件标识
        EMD_CombatPetCSId = 2138, //  战宠副本进入标识
        EMD_FirstRecharge = 2139, //  重置充值送绑元活动
        EMD_ZhanJiaCSId = 2140, // 战甲副本 标识
        EMD_FreeChallengeZhanJiaCS = 2141, // 免费挑战战甲副本标识
        EMD_ZhanJiaBuyCount = 2142, // 单次战甲副本购买次数
        EMD_ZhanJiaNowCSId = 2143, // 本次挑战的战甲ID
        EMD_ZhanJiaShopMark = 2144, // 战甲商店购买标识 临时使用

        //EMD_Start_ShopTypeRefreshDataId = 2145,//shopType表用到站位
        EMD_MergeSignInIndex = 2146,  //SYHXianYuShengHuiBase表用到
        EMD_MergeTotalRecharge = 2147,  //SYHXianYuShengHuiBase表用到
        EMD_Start_ShopTypeRefreshDataId = 2150,//shopType表用到站位
        EMD_End_ShopTypeRefreshDataId = 2160,//shopType表用到站位结束
        EMD_WorldBossCount8 = 2161,// 魂环boss
        EMD_WorldBossCount9 = 2162,// 青玄战阵boss

        EMD_SignLevelIndex = 2163,//签到等级下标记录

        EMD_OnLineGiftDailyLevel = 2164,        //在线奖励每日等级

        EMD_AddItemYuanBaoDay = 2165,        //每日通过道具获取元宝日期，和2166配合判断
        EMD_AddItemYuanBaoDailyNum = 2166,        //每日通过道具获取元宝总数
        EMD_WorldBossCount10 = 2167,// 
        EMD_ChangeJob7Stage = 2168,//7转计数
        EMD_NewTreasureLuckCount = 2169,//新寻宝幸运值
        EMD_NewTreasureHuaShenLuckCount = 2170,//化神寻宝幸运值
        EMD_NewTreasureLuckCountNew = 2171,//新寻宝幸运值
        EMD_NewTreasureHuaShenLuckCountNew = 2172,//化神寻宝幸运值


        ClearAllStarWishItemCount = 2201,// 临时清除玩家活动物品兑换次数

   

        /*※※※ 2210~2260，此间断为掉落表记录md值预留！！！特此声明！！！ ※※※*/
        EMD_DropRandomStart = 2210, //掉落表md开始
        EMD_DropRandomEnd = 2260, //掉落表md结束

        /*※※※ 2261~2270，此间断为新寻宝记录md值预留！！！特此声明！！！ ※※※*/
        EMD_NewTreasureStart = 2261, //新寻宝md开始
        EMD_NewTreasureEnd = 2270, //新寻宝md结束

        /*※※※ 2271~2295，此间断为直购礼包记录md值预留！！！特此声明！！！ ※※※*/
        EMD_DirectBuyGiftStart = 2271,//直购礼包
        EMD_DirectBuyGiftEnd = 2295,//直购礼包

        EMD_DailyConsume = 2299,        //每日消费元宝

        EMD_ShenYuCaptureFlagDailyCount = 2300,
        EMD_ShenYuFengLu = 2301,
        EMD_WorldBossCount11 = 2302,// 神域boss次数
        EMD_WorldBossCount13 = 2303,// 神域秘境boss次数

        EMD_MissionDeal_1632 = 2400,// 是否处理了1632任务

        EMD_PickXianMengCrystal = 2401,         //八转采集仙盟矿的数量
        EMD_KillWorldBossCount = 2402,          //八转击杀神域/世界boss数量
        EMD_KillPersonBossCount = 2403,         //八转击杀个人Boss数量
        EMD_KillShenMoJiangYuBossCount = 2404,  //八转击杀神魔疆域Boss数量
        EMD_KillHongHuangJingBossCount = 2405,  //八转击杀洪荒镜Boss数量

        EMD_ShenMoJiangYuBuyCount = 2410,   //神魔疆域购买击杀boss次数
        EMD_ShenMoJiangYuKillCount = 2411, //神魔疆域已击杀boss次数

        EMD_GetWishAwaryTimes4 = 2412,      //经验祈福免费次数

        EMD_QiYuanBaoGeCount = 2413,        //祈愿宝阁次数 
        EMD_QiYuanBaoGeActivityId = 2414,
        EMD_QiYuanBaoGeRewardId = 2415,
        EMD_QiYuanValueId = 2416,           //祈愿值

        /*※※※ 2420~2479，此间断精灵盛殿物品商店兑换预留！！！特此声明！！！ ※※※*/
        EMD_ActivityItemMDID4_0 = 2420,     //密卷商店
        EMD_ActivityItemMDID4_20 = 2439,
        EMD_ActivityItemMDID5_0 = 2440,     //秘宝商店
        EMD_ActivityItemMDID5_20 = 2459,
        EMD_ActivityItemMDID6_0 = 2460,     //信物兑换
        EMD_ActivityItemMDID6_20 = 2479,

        EMD_RechargeCardUseDay = 2481,      //充值卡使用日期
        EMD_RechargeCardUseNum = 2482,      //充值卡使用次数

        EMD_MiJuanActivityId = 2490,
        EMD_MiBaoActivityId = 2491,
        EMD_XinWuActivityId = 2492,

        EMD_FireWorksItem = 2493,
        EMD_FireWorksActivityId = 2494,

        EMD_TotalRechargeTianYu = 2500,//累计充值天玉数量
        EMD_ArcheanRelicsActiveId = 2520, // 太古遗迹活动id

        /*※※※ 2510~2549，此间断rmb禮包预留！！！特此声明！！！ ※※※*/
        EMD_RMB_START2 = 2521,
        EMD_RMB_END2 = 2549,

        /*※※※ 2550~2700，此间断直购礼包(特权)预留！！！特此声明！！！ ※※※*/
        EMD_DirectPurchaseStart = 2550,
        EMD_DirectPurchaseEnd = 2700,

        EMD_BaiWanActivityId = 2701,
        /*※※※ 2702~2706，占用！！！特此声明！！！ ※※※*/
        EMD_BaiWanActivityRewardStart = 2702,
        EMD_BaiWanActivityRewardEnd = 2706,

        EMD_YesterdayVitality = 2707,
		EMD_JianBaoGeCount = 2708,        //鉴宝阁次数 
        EMD_JianBaoGeActivityId = 2709,
        EMD_JianBaoGeRewardId = 2710,
        EMD_JianBaoGeValueId = 2711,      //鉴宝阁值

        EMD_BaiWanActivityId2 = 2712,
        /*※※※ 2713~2717，占用！！！特此声明！！！ ※※※*/
        EMD_BaiWanActivityRewardStart2 = 2713,
        EMD_BaiWanActivityRewardEnd2 = 2717,

        EMD_SeckillExpiry = 2721,

        EMD_NiuDanJiCount = 2725,        //扭蛋机次数 
        EMD_NiuDanJiActivityId = 2726,
        EMD_NiuDanJiRewardId = 2727,
        EMD_NiuDanJiValueId = 2728,      //扭蛋机进度值

        EMD_TiKuanJiEDuMDID = 2729,//提款机每日已使用额度
        EMD_DailyKillMonster = 2730,//提款机每日已使用额度
        EMD_DailyBuyXianShiMiaoSha = 2731,//提款机每日已使用额度
        EMD_CashBankGetAllVouchNum = 2732,//代充银行已提取额度

        EMD_TotalRMBRechargeMoney = 2733, //真实的RMB充值金额
        EMD_LastRMBRechargeDate = 2734,	    //上次RMB充值日期
        EMD_DailyRMBRechargeMoney = 2735,	//每日充值RMB数

        /*※※※ 2741~2759，此间断大直购每日免费礼包预留！！！特此声明！！！ ※※※*/
        EMD_DirectBuyRewardStart = 2741,      
        EMD_DirectBuyRewardEnd = 2759,

        /*※※※ 2760~2769，此间断合服排行活动每日免费礼包预留！！！特此声明！！！ ※※※*/
        EMD_MergeRankDailyRewardStart = 2760,
        EMD_MergeRankDailyRewardEnd = 2769,

        /*※※※ 2781~2785，此间断冲级礼包预留！！！特此声明！！！(配在RMB表中) ※※※*/
        EMD_ChongJiGiftStart = 2781,
        EMD_ChongJiGiftEnd = 2785,

        EMD_ConsumeAuctionDailyCount = 2801,     //拍卖行每日消费次数

        EMD_FirstRechargeNew = 2802,    //新首充
        EMD_ChongJiGiftAward = 2803,    //冲级礼包

        /*※※※ 2804~2850，此间断大直购每日免费礼包预留！！！特此声明！！！ ※※※*/
        EMD_DirectBuyRewardStart2 = 2804,
        EMD_DirectBuyRewardEnd2 = 2850,

        EMD_FirstRechargeNewStart = 2851,
        EMD_FirstRechargeNewEnd = 2859,

        /*※※※ 2860~2880，此间断自选礼包预留！！！特此声明！！！(配在RMB表中) ※※※*/
        EMD_ZiXuanGiftStart = 2860,
        EMD_ZiXuanGiftEnd = 2880,

        /*※※※ 3000~3200，此间断RMB礼包预留！！！特此声明！！！(配在RMB表中) ※※※*/
        EMD_RMBNewGiftStart = 3000,
        EMD_RMBNewGiftEnd = 3200,

        EMD_VipLimitAddWorldBossCount = 3201,   //增加WorldBoss击杀次数卡

        EMD_TotalLoginDays = 3202,  //累计登陆天数
        EMD_VipDailyGiftNew = 3203, //新的VIP每日领取奖励标记

        EMD_OfflineCompetionWinCount = 3205,//竞技场胜利次数
        EMD_JiLingGetDailyRewardCount = 3206,//寄灵领取每日奖励次数
        EMD_JiLingTanSuoCount = 3207,//寄灵每日探索次数
        EMD_ShenYuGetFlagCount = 3208,//神域夺旗数量
        EMD_ShenYuKillBossCount = 3209,//神域boss击杀数量
        EMD_ShenYuKillPlayerCount = 3210,//神域玩家击杀数量
        EMD_XiLianFuBenCount = 3211,//通关神玉遗址
        EMD_WuHunFuBenCount = 3212,//通关真武战场
        EMD_WanXiangShuYuan1Count = 3213,//通关万象书院副本1
        EMD_WanXiangShuYuan2Count = 3214,//通关万象书院副本2
        EMD_WanXiangShuYuan3Count = 3215,//通关万象书院副本3
        EMD_WanXiangShuYuan4Count = 3216,//通关万象书院副本4
        EMD_WanXiangShuYuan5Count = 3217,//通关万象书院副本5
        EMD_WanXiangShuYuan6Count = 3218,//通关万象书院副本6

        /*※※※ 3220~3270，此间断妖神山预留！！！特此声明！！！(配在CombatPetBase表中) ※※※*/
        EMD_YaoShenShanFuBenStart = 3220,
        EMD_YaoShenShanFuBenEnd = 3270,

        //TD记录打点
        EMD_Total_Revenue = 3271,   //累计付费金额
        EMD_Pay_Numer = 3272,       //支付次数
        EMD_Activit = 3273,         //累积活跃天数
        EMD_Current_Task_Progress = 3274,   //关键任务进度
        EMD_VipDailyGiftGetFlag = 3276, //新的VIP首次领取奖励标记,按位计算

        //荣耀抽奖
        EMD_RongYaoLotteryCount = 3277,         //荣耀抽奖次数
        EMD_RongYaoLotteryActivityId = 3278,    //荣耀抽奖本期活动ID
        EMD_RongYaoLotteryGeRewardId = 3279,    //荣耀抽奖领取奖励记录

        /*※※※ 3300~3400，此间断连续购买预留！！！特此声明！！！(配在连续购买表中) ※※※*/
        EMD_ContinueBuyStart = 3300,
        EMD_ContinueBuyEnd = 3400,

        EMD_Max = GameDefineMission.MaxMissionDataId,
    }

    public enum EMissionFlagId : int
    {
        EMF_Invalid = -1,

        EMD_GuideStart = 0,
        EMD_GuideEnd = 128,

        EMF_GetAutoPickup = 129,    //是否已经完成获取自动捡起掉落的守护的任务
        /*※※※ 130~140之间不允许采用，此间断为首充记录 预留！！！特此声明！！！ ※※※*/
        EMF_RechargeItemState_Start = 130,
        EMF_RechargeItemState_End = 140,
        EMF_FuLiDaTing1 = 141,
        EMF_FuLiDaTing2 = 142,
        EMF_FuLiDaTing3 = 143,
        EMF_FuLiDaTing4 = 144,
        EMF_FuLiDaTing5 = 145,
        EMF_FuLiDaTing6 = 146,
        EMF_FuLiDaTing7 = 147,
        EMF_FuLiDaTing8 = 148,
        EMF_FuLiDaTing9 = 149,

        EMF_ExpCSExpLost = 191, // 是否已经找回本次经验的丢失经验
        EMF_EquipShouHu = 192,

        EMF_RiChangAccept = 193, //日常试炼接受标志
        EMF_OpenFirstPunch = 194,
        EMF_FreeChangeName = 195,
        EMF_VIPExpires = 196,
        EMF_OpenFirstPunch_2 = 197,

        /*※※※ 200~300之间不允许采用，此间断为惊喜限购 预留！！！特此声明！！！ ※※※*/
        EMF_JingXiXianGouStart = 200,
        EMF_JingXiXianGouEnd = 300,
        /*※※※ 300~310之间不允许采用，此间断为应用宝奖励 预留！！！特此声明！！！ ※※※*/
        EMF_YingYongBao_Start = 301,
        EMF_YingYongBao_End = 310,

        //天道圣院S通关记录
        EMF_TianDaoShengYuan_S_Start = 311,
        EMF_TianDaoShengYuan_S_End = 320,
        //天道圣院A通关记录
        EMF_TianDaoShengYuan_A_Start = 321,
        EMF_TianDaoShengYuan_A_End = 330,

        EMF_MemoryChallenge_RoundResult1 = 331,
        EMF_MemoryChallenge_RoundResult2 = 332,
        EMF_MemoryChallenge_RoundResult3 = 333,

        EMD_WeddingFlag = 334,//是否可以预约婚礼

        // 335 ~350 礼包活动用 RMB 表
        EMF_RMBGiftFlag_Start = 335,
        EMF_RMBGiftFlag_End = 360,

        EMF_Level2PwdStage = 362,//false 没上锁   true 上锁
        EMF_Level2PwdFlag = 363,

        EMF_GetVipGiftStart = 365,
        EMF_GetVipGiftEnd = 384,

        EMF_FreeVip1 = 390,
        EMF_FreeVip2 = 391,
        EMF_FreeVip3 = 392,
        EMF_ForeverVip = 393,

        EMF_YunGouDayFirstBuy = 394,

        EMF_LevelRewardFLag = 395,

        EMF_PersonBossFreeFLag = 396,
        //400 ~799 判断是否为第一次功能开启专用 FunctionBase表
        EMF_FunctionOpen_Start = 400,
        EMF_FunctionOpen_End = 799,

        EMF_GetFirstTimeTreasure = 800,//第一次寻宝
        EMF_FreePersonBossFirstKill = 801,
        EMF_TreasureDoubleReward = 802,//天符宝阁双倍奖励开关
        //900 ~999 判断是否击杀了世界boss WorldBoss表 (boss首杀活动以及洞天福地boss首杀免费机制所使用)
        EMF_WorldBossKill_Start = 900,  
        EMF_WorldBossKill_End = 999,

        EMF_KillFreeBossFlag = 1000,

        EMF_VipProbationFlag = 1001,

        EMF_CardAutomaticStatu = 1002,//卡牌的自动分解状态

        EMF_CardActivityIsOpen = 1003,// 卡牌是否显示页签

        EMF_MissionCompleteFlage = 1004, //完成77任务记录

        EMF_ShopJinXiangYuFlag = 1005, //商城金镶玉道具购买标识

        EMF_MissionCompleteFlage2 = 1006, //完成71任务记录

        EMF_IsGetItemTreasureHighReward = 1007,//是否得到过寻宝大奖

        EMF_ClearVipFlag = 1008,
        //1009 ~1019 判断是否需要显示装备融神的新字 EquipFusionBase表
        EMF_EquipSuitShowNewIconStart = 1009,
        EMF_EquipSuitShowNewIconEnd = 1019,

        //天道圣院2S通关记录
        EMF_TianDaoShengYuan2_S_Start = 1020,
        EMF_TianDaoShengYuan2_S_End = 1030,
        //天道圣院2A通关记录
        EMF_TianDaoShengYuan2_A_Start = 1031,
        EMF_TianDaoShengYuan2_A_End = 1041,

        //特定boss首杀掉落
        EMF_BossFirstKill_Start = 1042,
        EMF_BossFirstKill_End = 1142,

        EMF_RandomShopFirstRefresh = 1143,
        //领取发松贺卡的标识符
        EMF_GetGreetingCardReward_1 = 1144,
        EMF_GetGreetingCardReward_2 = 1145,
        EMF_GetGreetingCardReward_3 = 1146,
        //记录今日是否完成了节日任务
        EMF_CompleteGreetingCardMissionFlag = 1147,
        EMF_GreetingCardEndMark = 1148,

        EMF_Welfare = 1149,//福利号标识

        EMF_TianXingBaoGeBigRewardFlag= 1150,//天星宝阁大奖是否已获得
        EMD_ChangeJob7CopyScene = 1151,

        //掉落表1160-1210间已用，不可插入中间。
        EMF_RandomDropStart = 1160,
        EMF_RandomDropEnd = 1210,

        EMF_DreamLandSeeAnimationStart = 1211,//幻境动画是否观看完
        EMF_DreamLandSeeAnimationEnd = 1260,//幻境动画是否观看完

        EMF_ChangeJob8CopyScene = 1261,
        EMF_ChangeJobMissionActivityCountState = 1262,

        EMF_FirstLoginReward = 1263,

        /*※※※ 1285~1310之间不允许采用，此间断为特权激活记录 预留！！！特此声明！！！ ※※※*/
        EMF_PrivilegeStart = 1285,
        EMF_PrivilegeEnd = 1310,

        EMF_CreateRunningMonster = 1320,

        EMF_SeckillBuy = 1321,

        /*※※※ 1330~1339，此间断合服排行活动每日免费礼包预留！！！特此声明！！！ ※※※*/
        EMF_MergeRankDailyRewardStart = 2760,
        EMF_MergeRankDailyRewardEnd = 2769,

        EMF_JuBaoPenCanBuy = 2788,
        /*※※※ VipEnjoyGift扩充等级预留VIP领取标记区间※※※*/
        EMF_GetVipGiftStart2 = 2790,
        EMF_GetVipGiftEnd2 = 2809,
        /*※※※ VipEnjoyGift扩充等级预留VIP领取标记区间※※※*/
        EMF_GetVipGiftStart3 = 2810,
        EMF_GetVipGiftEnd3 = 2839,

        EMF_AlreadyClickFacebookUrl = 2845,
        EMF_AlreadyGetFacebookReward = 2846,
        EMF_AlreadyClickFBCommunityPanel = 2847,
        EMF_AlreadyClickFBKeFuPanel = 2848,

        EMF_Max = GameDefineMission.MaxMissionFlagId,
    }

    public enum EMission_Type
    {
        Mission_Invalide = -1,
        Mission_Main,
        Mission_Branch,
        Mission_Daily,
        Mission_Copy,
        Mission_ChangeJob,
    }


    public enum EMission_Check_Result
    {
        Mission_Cannt_Accept,
        Mission_Can_Accept,
        Mission_Dosing,
        Mission_Have_Done
    }

    public enum EMission_State
    {
        Mission_Invalid = 0,
        Mission_Accepted,
        Mission_Completed,
        Mission_Failed,

    }

    public enum EMission_Logic_Type
    {
        Logic_Invalid = -1,
        Logic_Story,
        Logic_KillMonster,//杀怪
        Logic_Delivery,//送信
        Logic_CollectItem,//采集
        Logic_EnterArea,//探索
        Logic_LootItem,//寻物
        Logic_CopySceneMonster,//副本杀怪
        Logic_LevelUp,//升级
        Logic_UseItem,//使用道具
        Logic_OperationCount,//
        Logic_Puzzle,//
        Logic_Guide,//指导
        Logic_AttacksNum,//攻击次数
        Logic_Round,//
        Logic_Script,//脚本
        Logic_Npc_Follow,//npc跟随
    }

    public enum EScript_Logic_Type
    {
        Type_Zhuagui = 1,
        Type_Weizhentianxia = 2,
        Type_Story = 100,
        Type_Delivery = 101,
        Type_KillMonster = 102,
        Type_CollectItem = 103,
        Type_LootItem = 104,
        Type_BuyItem = 105,
        Type_ChuanshuoClass = 106,
        Type_ChuanshuoId = 107,
        Type_Puzzle = 108,
        Type_Treasure = 109,
        Type_CopyScene = 110,
    }


    public enum EMission_Event
    {
        Event_Kill_Object,
        Event_EnterArea,
        Event_ItemChange,
        Event_LevelUp,
        Event_CollectItem,
        Event_UseItem,
        Event_Puzzle,
        Event_TeamKill,
        Event_TeamCollect,
        Event_CopyScene,
        Event_Guide,
        Event_Attacks,
        Event_Attribute,
        Event_Round,
    }

    public enum EMission_RoundType
    {
        Round_Common = 0,
        Round_Puzzle,
        Round_Script,
    }

    public enum ERound_Id
    {
        WeiZhenTianXia = 5,
        Daily = 19,
        Guild = 11,
        Puzzle = 20,
        Puzzle_Single = 21,
    }

    public enum EMission_RoundCooldownType
    {
        CooldownDialy = 0,
        CooldownWeek,
    }

    public enum EMission_LootItem_Type
    {
        LootItem_KillMonster = 1,
        LootItem_Shop = 2,
        LootItem_Auction = 3,

    }

    public enum EAutoSearch_ChangeSceneType
    {
        Change_Type_Mission = 0,
        Change_Type_UseItem = 1,
        Change_Type_Free = 2,
        Change_Type_Guild = 3,
    }

    public enum EMissionFailedType
    {
        FailedType_Logout = 0,
        FailedType_TimeOut = 1,

        FialedType_Count
    }

    public enum EDialogCustomFunc
    {
        Func_Jump_TeamPlatformUI = 0,
        Func_Jump_TowerPanel = 1,
        Func_RoundMission = 2,
    }

    public enum EMissionLevelUpType
    {
        Type_Level,
        Type_Realm,
        Type_HuaShenLevel,
    }

    public enum EVipHaoliTaskType
    {
        Invalid = -1,
        VipLevel = 0,
        ObtainItem = 1,
        VipInvest = 2,
        BossInvest = 3,
        YuanbaoInvest = 4,
        YueKaInvest = 5,
        Max
    }

}
