﻿namespace Shark
{
    public class GameDefineMail
    {
        public const bool MailLog = false; // 邮件日志开关
        public const int MaxAttachmentNum = 5; // 每封邮件中附件的最大数量
        public const int InboxMailNum = 20; // 玩家收件箱中最多显示的邮件数量
        public const int TestMailId = 100; // 测试邮件起始ID
        public const int MinLevelTMLKey = 30; // 发送天梦林钥匙最低等级
        public const int MaxMailNumTMLkey = 7; // 天梦林钥匙邮件有效期
        public const int TMLKeyMailId = 20; // 天梦林钥匙起始ID
        public const int MinTower = 101; // 最小的爬塔奖励层数
        public const int TowerMailId = 999; // 最小的爬塔奖励邮件ID

        public const int LadderNormalMailId = 800;
        public const int LadderTopHundredMailId = 801;
        public const int ZhongShenDianMailId = 802;
        public const int LadderXinRuiMailId = 803;
        public const int FirstPunchLoginMailId = 20;
		public const int BagFullMailId = 9998;
        public const int BlackCardTicket = 23001;
        public const int BlackCardBonus = 23002;

        public const int MergeRankMailStarSoul = 2500;      //合服排行-神仆
        public const int MergeRankMailConsume = 2501;       //合服排行-消费
        public const int MergeRankMailWarPet = 2502;        //合服排行-战宠
        public const int MergeRankMailRecharge = 2503;      //合服排行-充值
        public const int MergeRechargeMail = 2510;          //合服累计充值
    }

    public enum EMailState
    {
        NoAttNotOpen = 1, // 玩家未打开邮件(无附件)
        AttNotReceive, // 玩家未领取附件
        AttReceive, // 玩家已领取附件
        NoAttOpen, // 玩家已打开邮件(无附件)
    }

    public enum EMailEvent
    {
        Open = 1,
        Delete = 2,
    }

    public enum EMailAttachmentType
    {
        invalid = -1,
        Money = 0,                     // (废弃)
        YuanBao = 1,                 // 元宝
        BindMoney = 2,             // 金币
        Sense = 3,                      // 感知力
        Vitality= 4,                     // 活力
        Arena = 5,                      // 竞技场
        PvpMoney = 6,               // PVP
        TeamMoney = 7,            // 队长积分
        CardScore = 8,               // 卡牌
        GuildMoney = 9,            // 帮贡
        PetPoint = 10,                // 妖兽洗炼积分
        RuneSpar = 11,              // 符文魔晶
        Chivalrous = 20,            // 侠义值
        BindYuanBao = 21,       // 绑定元宝
        XunBaoMoney = 22,     // 寻宝积分
        Exp = 30,                       // 经验
        ComItem = 31,              // 道具
        EquipItem = 32,             // 装备
    }
}
