namespace Shark
{
	public class GameDefineItem
	{
	    public const int CardItemMod = 120000000;
        public const int TITLE_ITEM_MOD = 10000000;
		public const int BagMaxUnlock = 280;
        public const int TmpBagSizeMaxCount = 20;
        public const int TmpBagCanDecomposeCount = 5;
        public const long DayTime = 1000 * 60 * 60 * 24;
        public const long TmpBagExistTime = 1000 * 60 * 60 * 6;
        public const int ZhenFaItemUseCount = 5;
        public const int CanDecomposeLevel = 20;
        public const int WarehouseSizeDefault = 60;
        public const int MaxWarehouseUnlockedCount = 50;
	    public const int BindMoneyItemId = 150000010;
        public const int BindMoneyGoldItemId5 = 107000080;
        public const int BindMoneyGoldItemId10 = 107000081;
        public const int BindMoneyGoldItemId20 = 107000083;
        public const int XIAN_LIAN_MAX = 11;
	    public const int MinStepEquipZhuHun = 7;
        public const int WorldCupBoxId = 105103101;

        public const int WelfareAuctionTopPrice = 20;

        //装备收集常量
        public const int EquipCollectionMaxCount = 14;      //4到17阶装备
        public const int EquipCollectionPosMaxCount = 7;    //7个装备位
        public const int EquipCollectionPosPass = 2;        //2位置暂缺

        public static int GetRMBAttrValue(EPropertyType eProperty,int nUserLvl,out EPropertyType refixProperty)
        {
            int nValue = 0;
            int nIdx = -1;
            refixProperty = EPropertyType.EProperty_Invalid;
            switch (eProperty)
            {
                case EPropertyType.EProperty_RMB_AttackRecoverHpPerLvl:
                    {
                        refixProperty = EPropertyType.EProperty_AttackRecoverHpPvp;
                        nIdx = 0; 
                    }
                    break;
                case EPropertyType.EProperty_RMB_AttackIncDamage:
                    {
                        refixProperty = EPropertyType.EProperty_DamageInc;
                        nIdx = 1;
                    }
                    break;                
            }

            Tab_RMBAttribute vInfo = Tab_RMBAttributeProvider.Instance.GetDataById(nUserLvl);
            if(nIdx >= 0&&vInfo != null && vInfo.ParamList.Count>nIdx)
            {
                nValue = vInfo.ParamList[nIdx];
            }

            return nValue;
        }
	}

	public enum EItemBindType:int
	{
		BindNever=0,
		BindOnReceive,
		BindOnUse,
	}

	public enum EItemClass:int
	{
		EItem_CommonItem = 10,
        EItem_Equip = 11,
        EItem_Card = 12,
        EItem_Title = 13,
        EItem_Pose=14,//休闲动作
        EItem_Rune = 16,
        EItem_JuHun = 17,
        EItem_JuHun2 = 18,
        EItem_ShenShou = 20,
        EItem_BenYuan = 21,
        EItem_JieYuan = 22,
        EItem_XingHun = 23,
        EItem_XingHunEquip = 24,
        EItem_ShenWangEquip = 25,
        EItem_WarPetEquip = 26,
        EItem_JiLingItem = 27,
        EItem_ShenZhuang = 28,
        EItem_OldGodItem = 33,
        EItem_OldGodDiamond = 34,
        EItemClass
    }

	public enum EItemOptResult : int
	{
		ERslt_UseSuccess = 0,
		
	}

	public enum EItemUseLogicId:int
	{
        ELimit_Invalid = 0,
        ELogic_Gohome,
        ELogic_AddMission,
		ELogic_AddHp,
        ELogic_GiftBox,
        ELogic_CreateMonster,

        Elogic_Impact = 15,
        Elogic_StarSoulSkin,
        Elogic_DelNegative = 19,
        Elogic_Avatar,
        Elogic_AutoSreach,
        Elogic_LimitMoney = 23,
        Elogic_Wing = 24,
        Elogic_CardOC =25,
        Elogic_ExpRate =26,
        Elogic_RuneBox =27,
        Elogic_AddCopySceneCount=28,
        Elogic_RunesRandom = 29,
        Elogic_AddExp = 30,
        Elogic_AddVip = 31,
        Elogic_UseLuaScripts = 32,
        ELogic_VIPInvest7Days = 33,
        ELogic_ShowUI = 34,
        ELogic_JuHunBox = 35,
        ELogic_PetMount = 36,
        ELogic_StageGift = 37,
        ELogic_ChangeMenPai = 38,
        ELogic_ZhanShouBox = 39,
        ELogic_ArtifactBox = 40,
        ELogic_WorldCup = 41,
        ELogic_BenYuan = 42,
        ELogic_LingBao = 43,
        ELogic_LadderHonor = 44,
        ELogic_LadderJiFen = 45,
        ELogic_XianHua=46,
        Elogic_YanHua=47,
        ELogic_AddLadderCount = 48,
        ELogic_AddMarryTime = 49,
        ELogic_PeiShiSuiPian = 50,
        ELogic_JieYuan = 51,
        ELogic_XingHunLevelUp = 52,
        ELogic_ZhuanJing = 53,
        Elogic_PeiShi = 54,
        ELogic_ShowGiftBox = 55,
        ELogic_Emotion = 56,
        ELogic_LingGang = 60,
        ELogic_LingGangLevelUp = 61,
        Elogic_AddVipTime = 62,
        Elogic_StarSoul=63,
		Elogic_MarryXinWu = 64,
        Elogic_ShowUIGiftBox = 65,
        ELogic_AddXingWenSource = 80,
        ELogic_AddGreetingCard = 81,
        ELogic_DestinyStarArray = 82,

        ELogic_ZhanJiaCurrency = 83,
        ELogic_ZhanJiaAndJieYuan = 84,
        ELogic_ShenWangZhanJia = 85,
        ELogic_WarPetArrayLevelUp = 86,

        ELogic_AddBattlefieldMoney = 87,
        ELogic_XingYunUserItemAddYunShi =88,

        ELogic_XingYunZhiYi = 89,
        ELogic_YuanShenExp = 90,
        ELogic_ItemAddYuanShenExpRate = 91,
        ELogic_YuanShenAddExpRate = 92,
        ELogic_YuanShenAddLevelOrExp = 93,

        ELogic_ReduceShenYuCopyTired = 95,
        ELogic_LightStarCraft = 96,
        ELogic_AddPassiveSkill = 97,

        ELogic_OldGodItem = 98,
        ELogic_OldGodDiamond = 99,

        ELogic_RechargeCard = 100,
        ELogic_Privilege = 101,
        ELogic_YuanBao = 102,
        ELogic_Job = 103,
        ELogic_Artifact = 104,  //赛季神器激活和升级
        ELogic_RefreshWorldBoss = 110,  //道具刷新世界Boss
        Elogic_AddWorldCountCount = 111,//道具增加世界Boss击杀次数
        ELogic_ReduceShenYuCopyTired13 = 112, //道具增加神域秘境boss挑战次数
        ELogic_PetSoulStone = 113,  //属性丹道具直接使用逻辑
    }
    public enum EItemAddExpType
    {
        ETypeAddExp_Adapt = 1, // 固定和自适应
        ETypeAddExp_Fix = 2,
        ETypeAddExp_Level = 3,
    }
    public enum EItemUseLimitType
    {
        ELimit_Invalid = 0,
        ELimit_Forever = 1,
        ELimit_Week = 2,
        ELimit_Day = 3,
    }

    public enum ECoinType
    {
        ECoin_YuanBao = 0,
        ECoin_Money,
        ECoin_BindMoney,
        ECoin_Exp,
        
    }

    public enum EItemType
    {
        Invalid = 0,
        ComItem = 1,        //普通物品
        Medicine = 2,       //药品
        TaskItem = 3,       //任务道具
        Equipment = 4,      //武器装备
        FriendGift = 5,     //礼物
        Diamond = 6,        //宝石
        GodWordCharm = 7,   //临时符
        EquipSetStone = 8,  //套装石
        ZhenFaItem = 9,     //阵法
        AddImpact = 10,      //增加buff
        AddLimitMoney = 11,  //增加限制金钱
        LingPuExp = 12,     //灵仆经验丹
        ShenWen = 16,        //神纹
        LingPuOpt = 17,     //灵仆专用
        ShenWenRandom = 18, //随即神纹
        ShenQiEquip = 20,    //天梯神器 
        HunJiangSuiPian = 22,  //魂将碎片
        Card = 24,          //卡牌
    }

    public enum ESubItemType
    {
        ShenWangZhanJia = 7,//神王战甲
        MaterialItem = 30,   //材料
       
    }


    /// <summary>
    /// 增加此枚举时，相应的要在ItemGetPath这个表（在server里）里增加一个字段
    /// </summary>
    public enum EItemSource
    {
        Invalid = 0,

        DropOut,                //掉落
        Compose,                //合成
        GiftBox,                //礼包
        ItemTreasure,           //极品寻宝
        RuneTreasure,           //神纹寻宝
        Shop,                   //商店

        SevenDaysGift,          //七天
        SignGift,               //签到
        LevelGift,              //等级礼包
        OnlineGift,             //在线奖励
        ShenQiRenZhuGift,       //神器认主
        CDK,                    //CDK
        KaiFuJiZi,              //开服集字
        KaiFuPaiHang,           //开服排行
        Auction,                //拍卖行
        RechargeGift,           //充值
        VipInvest,              //VIP投资
        FirstRecharge,          //首充
        Mail,                   //邮件
        Tower,                  //通天塔
        Mission,                //任务
        Section,                //章节
        OffLineGift,            //离线挂机
        ZhenXinHua,             //真心话
        YanJiShouKuai,          //眼疾手快
        FindReward,             //找回
        GuildWarehouse,         //势力仓库
        ActivityNum,            //活跃度奖励
        Achievement,            //成就
        UseItem,                //使用道具
        Decompose,              //分解
        KuangYeZhanTai,         //狂野站台
        GuidGongZi,             //势力工资
        ChangeDiamond,          //更换宝石
        MopUpCopyScene,         //副本扫荡
        YunGou,                 //云购
        XianYuShengHui,         //仙域盛会
        TaiGuJiTan,            //太古祭坛
        ShiLiLianSai,           //势力联赛
        CardCopyScene,          //卡牌本
        MoDuoJingJiChang,       //摩多竞技场
        GuildDefenceBattle,     //势力战
        PvpGift,                //PvP
        CopyScene,              //副本
        GM,                     //GM
        Crystal,                //采集水晶
        ChangeMenPai,           //转职
        TianXingBaoGe,          //天星宝阁
        TreasurePlace,          //藏宝之地
        Ladder,
        ShenShouSystemOpen,     //神兽功能开启
        JingXiXianGou,
        TmpItemBag,             //临时背包
        WorldCupShop,
        OppoGift,
        Split,                  //拆分
        BenYuanDecompose,
        FuLiDaTing,
        CardCompound,           //卡牌合成
        DailyRecharge, // 每日充值奖励
        MergeActivity,
        TreasureWarehouse,//寻宝仓库
        BossGongCheng,
        Warehouse,
        ZheKouShangDian,
        LingYuanGouBuy,
        MondayLuckDraw,
        AwardYuanBaoInvest,
        HunJiangXunBao,
        HunJiangJuHun,
        HunJiangRongLian,   //魂将熔炼
        TaiGuRelicBuyShop, //太古遗宝购买
        GetVipDailyGift,
        GetVipEnjoyGift,
        TimingBoxRew,//夜间礼包
        LuckyRoll,             //幸运转盘
        DuoBao,//夺宝
        CardXunBao,//卡牌寻宝
        CardFlopRew,//卡牌翻牌领取奖励
        CardJiBanRew,//卡牌羁绊领取奖励
        CardRankRew,//卡牌排行
        StarWish,//星语心愿
        MarryQingYuan, // 结婚系统
		AncientShopData, // 太古遗迹
        ChickFight, // 小鸡大作战
        GreetingCard,//贺卡
        PaintingReward, //光阴绘卷
        XingYunBlessEventReward,
        XingYunMissionReward,
        XingYunGuideEventExtraReward,
        BattlefieldBoss,
        TianXingBaoGeDirect,          //天星宝阁直购
        JiLingReward, //寄灵
        EquipStepUpChaiJie,// 装备拆解
        DiamondChaiJieWhenCompound,
        ChangeDiamondWithCuiLianLevel,
        ShenZhuangDecompose,
        ShenZhuangEquipCompound,
        EquipExchangeNewEquip,               
        DiamondChaiJie,
        NewTreasure,//新寻宝
        ShenYuFengLu,
        ShenYuFengHaoReward,
        ChengZhangLibao, //成长礼包
        ZhandouLibao, //战斗礼包        
        WuShuangZhanLingLibao, //无双战令
        ShenWangZhanLingLibao, //神王战令
        StarCraftOccupyReward,  //星域占领星球奖励
        StarCraftMenPiaoBonus,  //星域门票筹集奖励
        TianJiBaoGe,    //天机宝阁
        StarCraftFanPaiReward,  //星域翻牌奖励
        StarCraftCopyReward,  //星域副本奖励
        ChangeJob8MissionReward,
        OldGodItemCompound,
        OldGodDiamondCompound,
        TreasureHunt,   //全民寻宝
        QiYuanBaoGe,
        BlackCard,      //黑卡

        Pray,
        ZaDan,
        DirectPurchase,
        DirectBuyReward,
        JianBaoGe,
        MergeDirectBuyActivity,
        MergeRankActivity,
        MergeRechargeActivity,
        RechargeActivity,
        JuBaoFuDai,
        JuBaoFuDaiLottery,
        BaiWanJiJie,
        VipHaoli,
        ArenaRank,
        BaiWanJiJie2,
        BaiWanHaoLi,
        FacebookCommunity,

        RongYaoLottery, //荣耀抽奖
    }


    public enum EFriendGiftType
    {
        FriendGift_FriendPoint,//加友好度
        FriendGift_GiveItem,//生成另一个道具
    }
    public enum EItemDel
    {
        Invalid = 0,
        EItem_Use,//使用
        EItem_Compose,//合成
        EItem_Auction,//拍卖
        EItem_Sell,//卖商店
        EItem_GuidWarehouse,//势力仓库
        EItem_OutTime,//过期
        EItem_Decompose,//分解
        EItem_Mission,//任务
        EItem_TunShi,//吞噬
        EItem_ChangeMenPai,//转职
        EItem_ChangeName,//改名
        EItem_Artifact, //神器升级
        EItem_BenYuanStepUp,
        EItem_LingBao, //灵宝
        EItem_ZhuHun, //铸魂
        EItem_ShengLing,//圣灵
        EItem_LevelSeal,
        EItem_XingHunLevelUp,
        EItem_XingHunUnLock,
        EItem_ResetZhuanJing,
        EItem_ZhuanJingDcompose,
        EItem_Inlay,
        EItem_Warehouse,
        EItem_UnLockEquipPos,
        EItem_LingGangDecompose,
        EItem_LingGangSkillLevelUp,
        EItem_LingGangLevelUp,
        EItem_LingGangStageLevelUp,
        EItem_HunJiangXunBao,
        EItem_HunJiang,
        EItem_HunJiangRongLian,
        EItem_HunJiangLearnSkill,
        EItem_StarSoul,
        EItem_Destiny,

        EItem_LevelUpDestiny,
        EItem_UnlockNewBlood,
        EItem_DestinyBloodLevelUp,
        EItem_DestinyTemper,
        EItem_DestinyCulture,
        EItem_RollCost,
		EItem_UnlockSevenStart,
        EItem_CardXunBao,
		EItem_MarryXinWu,

        EItem_RealmPractice,
		EItem_AncientSeal,
        EItem_Fusion,
        EItem_UpdateGuildName,
        EItem_WingChange,


        EItem_WarPetCompose,
        EItem_WarPetSkillLevelUp,
        EItem_WarPetTalentLearn,

        EItem_WarPetStar,
        EItem_WarPetArrayLevelup,
        EItem_SoulPowerLock,
        EItem_SoulPowerUpOrLevel,

        EItem_UseItemAddXingYunYunShi,
        EItem_XianYuZhiYiLevelUp,
        EItem_LingGangXuLingLevelUp,
        EItem_JiLingAttrLevelUp,
        EItem_JiLingQiLIngLevelUp,
        EItem_JiLingJingJieLevelUp,
        EItem_GMDelectItem,

        EItem_ShouHuangXi,
        EItem_EquipStepUp,
        EItem_CuiLian,
        EItem_ShenZhiJingLevelUp,
        EItem_ResetShenShi,//神识重置
        EItem_WuXingYuanLi,//五行原力
        EItem_ShenZhuangDecompose,
        EItem_EquipFenJie,
        EItem_ShenZhuangEquipCompound,
        EItem_ShenZhuangEquipStepUp,
        EItem_UnLockEquipFav,
        EItem_ShenZhuangRingCompose,
        EItem_HongMengWeaponCompound,
        EItem_HongMengWeaponStepUp,
        EItem_EquipExchange,
        EItem_EquipExchangeOldEquip,
        DiamondChaiJie,
        EItem_GongZhen,
        EItem__NewTreasure,//新寻宝消耗
        EItem_ActiveDreamMember,
        EItem_LevelUpDreamMember,
        EItem_SkillUpDreamMember,
        EItem_LevelUpEquipDreamLandMember,
        EItem_AddUnlockDreamLandMember,
        EItem_FetterUpDreamLand,
        EItem_EquipChaiJie,
        EItem_ComprehendUp,
        EItem_UnlockOldGod,
        EItem_OldGodItemCompound,
        EItem_OldGodDiamondCompound,
        EItem_OldGodItemDecompose,
        EItem_OldGodDiamondDecompose,
        EItem_QiYuanBaoGe,
        EItem_Pray,
        EItem_MaiDian,
        EItem_JianBaoGe,
        EItem_RongYaoSuit,
        EItem_GoldenBadge,
        EItem_RongYaoLottery,
    }

    public enum EDealCdTypeByShop
    {
        NoDealCd = 0,
        Forever = 1,
    }

    //去除负面影响类型
    public enum EDelNegativeType
    {
        Type_QingXinDan = 0,
        Type_ManTianWan = 1,
    }

    public enum ESellItemType
    {
        Type_CommonItem = 0,
        Type_Equip = 1,
    }
    public enum EVipCardType
    {
        Type_High = 0,
        Type_BetWeen = 1,
        Type_Low = 2,
    }

    public enum EDropNoticeType
    {
        Type_Item = 0,
        Type_Equip = 1,
        Type_ShenShou = 2,
        Type_OldGodItem = 5,
        Type_OldGodDiamond = 6,
    }

    public enum EDropNoticeAskType
    {
        Type_GetNoticeList = 0,
        Type_LookEquip = 1,
    }

    public enum EItemBoxType
    {
        Type_Rune = 1,
        Type_JuHun = 2,
        Type_ShenShou = 3,
        Type_BenYuan = 4,
        Type_JieYuan = 5,
        Type_OldGodItem = 8,
    }

    public enum EHuLingType
    {
        Type_LingGong = 1,
        Type_LingYu = 2,
    }

    public enum EEquipGhostOptType
    {
        Type_UnLock = 0,
        Type_LevelUp = 1,
        Type_HuLing = 2,
        Type_SyncData = 3,
    }

    public enum EZhuHunType
    {
        ShenBing_Attack = 1,
        ShenBing_Hp = 2,
        BaoShi_Attack = 3,
        BaoShi_Hp = 4,
    }

    public enum EZhuHunPartType
    {
        ShenBing = 1,                
        BaoShi = 2,
    }

    //装备切换
    public enum EQuickChangeType
    {
        Type_Fav = 2,    //收藏快速换装
        Type_Equip = 1,    //装备快速换装
    }
}
