﻿namespace Shark
{
    public class GameDefineGuild
    {
        public const bool GuildLog = true;
        public const int MaxGuildLevel = 10;
        public const int MaxGuildFormationLevel = 18;
        public const int CreateGuildCostItemId = 102500064; // 创建势力所需道具id
        public const int CreateGuildMoney = 100000; // 创建势力所需金钱
        public const int CreateGuildLevel = 11; // 创建势力所需最低等级
        public const int MaxApplyGuildNum = 10; // 玩家同时申请的势力的最大数量
        public const int QuickApplyGuildNum = 5; // 一键加入功能随机申请的势力数量
        public const int MaxGuildAnnouncementNum = 20; // 势力事件最多保留数目
        public const int MaxGuildGroupCount = 11; // 势力最多小组数量
        public const int MaxGuildProposerNum = 30;  // 势力最大接受申请的数量
        public const int GuildSceneClassId = 100;         // 势力场景ID
        public const int GuildBattleSceneClassId = 101;         // 势力战场景ID
        public const int GuildFoodGeneral = 100; // 普通宴会所需食材数量
        public const int GuildFoodExcellent = 300; // 优秀宴会所需食材数量
        public const int GuildFoodTop = 600; // 特级宴会所需食材数量  
        public const int MaxGuildDinner = 900; // 势力晚宴捐献上限 
        public const int GuildDinnerMissionId = 14; // 势力晚宴起始环任务ID 
        public const int GuildDinnerRandomMissionCount = 4; // 势力晚宴随机任务数量
        public const int GuildDinnerNpcRoleBaseId = 40001; // 势力晚宴四阶段NPC
        public const int GuildDinnerNpcSceneNpcId = 60002; // 势力晚宴四阶段NPC
        public const int GuildDinnerActivityId = 28; // 势力晚宴活动ID
        public const int GuildDinnerDrunk = 5; // 晚宴醉酒互动最多点击次数
        public const int GuildDinnerGourmet = 5; // 晚宴佳肴互动最多点击次数
        public const int GuildDisbandMailTabId = 6; // 势力解散通知邮件ID
        public const int GuildDinnerMailTabId = 7; // 势力晚宴奖励邮件ID
        public const int MaxGuildFormationBossEnergy = 5; // 势力战阵BOSS激活
        public const int GuildFormationStartScriptId = 003014; // 势力战阵脚本ID
        public const int GuildRobberStartScriptId = 003002; // 势力强盗脚本号
        public const int GuildDinnerStartId = 106;
        public const int GuildDinnerEndId = 107;
        public const int GuildDinnerDebuff = 9996; // 势力晚宴互动时间眩晕Debuff

        public const int GuildTitleId = 130000001;//帮会的职务称号
        public const int GuildPlayerFormationBuff = 9998; // 战阵组队加成Buff
        public const int GuildFormationActivityBaseId = 31; // 守护朱雀ID
        public const int GuildFormationBoxId = 4300; // 守护朱雀宝箱ID

        public const int GuildBossActivityId = 43;
        public const int GuildBossItemId = 105600001;
        public const int GuildBossLimit = 5;
        public const int GuildBossItemGuildMoney = 100;
        public const int GuildBossItemGuildCapital = 1000;

        public const int GuildLuckyPacketDailyRechargeId = 200;
        public const int GuildLuckyPacketAccumulatedRechargeId = 201;

        public const int GuildBattleLeagueCount = 5;
        public const int GuildBattleLeagueGuildCount = 4;
        public const int GuildBattleSLeagueWinMail = 29;
        public const int GuildBattleSLeagueLoseMail = 30;
        public const int GuildBattleALeagueWinMail = 31;
        public const int GuildBattleALeagueLoseMail = 32;
        public const int GuildBattleBLeagueWinMail = 33;
        public const int GuildBattleBLeagueLoseMail = 34;
        public const int GuildBattleCLeagueWinMail = 35;
        public const int GuildBattleCLeagueLoseMail = 36;
        public const int GuildBattleDLeagueWinMail = 37;
        public const int GuildBattleDLeagueLoseMail = 38;

        public const int GuildBattleFirstMail = 41;
        public const int GuildBattleSecondMail = 42;
        public const int GuildBattleThirdMail = 43;
        public const int GuildBattleFirstZongZhuMail = 44;

        public const int GuildBattleFirstTitleId = 130000013;
        public const int GuildBattleSecondTitleId = 130000014;
        public const int GuildBattleThirdTitleId = 130000015;
        public const int GuildBattleZongZhuTitleId = 130000006;

        public const int GuildDefenceActivityId = 24;
        public const long GuildZongZhuChangeTime = 3 * 24 * 60 * 60 * 1000;     //宗主x时间内从未上线，系统自动转让宗主
        public const long GuildDissolveTime = 7 * 24 * 60 * 60 * 1000;     //x时间内没有一个成员在线，解散势力
        public const int GuildDissolveMailId = 601; // 没有活跃玩家势力解散邮件id
        public const int GuildZongZhuChangeMailId= 600; // 宗主不活跃，自动转让邮件id
        public const int IdVipLimitGuildLuckyPacket = 9;
        public const int VipLvlSendYBLuckyPacket = 6;
        public const int GuildHornItemId = 102500000;
        public const int GuildHornShopItemId = 1000001;
        public const int GuildDuoMaoMaoActivityId = 30;
        public const int GuildDuoMaoMaoGroupPointTime = 2 * 60 * 1000;
        public const int DuoMaoMaoGroupPointId_1 = 261;
        public const int DuoMaoMaoGroupPointId_2 = 262;
        public const int DuoMaoMaoHighMaxNum = 2;
        public const int DuoMaoMaoLowMaxNum = 5;
        public const int DuoMaoMaoHighPoint = 10;
        public const int DuoMaoMaoLowPoint = 5;
		public const int GuildCollectActivityId = 31; // 势力炼气活动ID
		public const int GasRefiningCollectBaselowNum = 7; //  普通玩家低级基础采集数量
		public const int GasRefiningCollectBaseMidNum = 5; //  普通玩家中级基础采集数量
		public const int GasRefiningCollectBaseHighNum = 2; //  普通玩家中级基础采集数量
		public const int GasRefiningHighType = 6008;
		public const int GasRefiningMiddType = 6009;
		public const int GasRefiningLowType = 6010;
		public const int GasRefiningMissMinID = 11190;  // 炼气任务最小ID
		public const int GasRefiningMissMaxID = 11197;  // 炼气任务最大ID


	}

    public enum EGuildPosition
    {
        ZongZhu= 1,
        FuZongZhu,
        GongFeng,
        Zuzhang,
        ZuYuan,
        QunZhong,
    }

    public enum EGuildSearchType
    {
        Digit = 1,
        Character,
    }

    public enum EGuildMessageType
    {
        Desc = 1,
        Weixing,
        Name,
    }

	public enum EGuildGasRefiningType
	{
		High = 6008,
		Midd,
		Low,
	}

	public enum EGuildChangeType
    {
        UnChanged = 1,
        Join, // 加入势力
        ExChange, // 更换势力
        Leave, // 脱离了势力
    }

    public enum EGuildEventType
    {
        Create = 1, // 创建势力
        Disband,    // 解散势力
        Join,           // 加入势力
        Kick,           // 踢出势力
        Quit,           // 退出势力
        Appoint,     // 职位任命
        Alert,          // 申请提醒
        Keep,         // 势力维护
        Auto,         // 自动加入
        Upgrade,  // 势力升级
        Dividend, // 势力分红
        Scene,      // 势力场景
        Assign,     // 势力战连胜奖励分配
        ChangeZongzhu  //宗主三天不在线转让他人
    }

    public enum EGuildSyncDataType
    {
        Id = 1,
        Name,
        Position,
        Scene,
        Alert,
        MemberAlert,
        GroupAlert,
        WelfareAlert,
        Dividend,
        CurContribute,
        FrozenContribute,
        Level,
        All,
    }

    public enum EGuildSceneType
    {
        Dinner = 1,
        Formation,
        Defence,
    }

    public enum EGuildApplyListType
    {
        Add = 1,
        Delete,
        Clear,
    }
    public enum EGuildTemporaryIncantation
    {
        Type_Succeed =1,
        Type_NoGuild,
        Type_NoItem,
        Type_Novitatlity,
        Type_NoNeed,
        Type_IsRequestTemporartIncantation,
        Type_IsUseTemporartIncantation,
        Type_NoTimes,
    }
    public enum EGuildDonationType
    {
        Type_Vitality=1,
        Type_Item,
    }

    public enum EGuildActivityType
    {
        Invalid = -1,
        Dinner,
        Noon,
        DefenceBattle,
        Boss,
        DuoMaoMao,
		GasRefining,
		Max,
    }
    public enum EGuildIncantationType
    {
        Type_Request = 1,
        Type_DonationType,
    }

    public enum EGuildDonateResult
    {
        Ok,
        Full,
        Already,
    }

    public enum EGuildDinnerUrlType
    {
        Drunk = 1,
        Food,
    }

    public enum EGuildFormationOpType
    {
        Enroll = 1,
        Start,
        End,
    }

    public enum EGuildCapitalType
    {
        GM = 1,
        Person,
        Mission,
        GuildBattleWin,
        GuildBattleLose,
        GuildDefenceWin,
        GuildDefenceLose,
        GuildRobberWin,
        GuildRobberLose,
    }

    public enum EGuildFormationType
    {
        Invalid = 1,
        GuildBattle,
        Team,
    }

    public enum EGuildWarehouseResultType
    {
        Type_Success=1,
        Type_NoGuild,
        Type_NoPlayer,
        Type_NoItem,
        Type_NoRoot,
        Type_NoSize,
        Type_NoMoney,
        Type_NoBag,
    }
    public enum EGuildWarehouseOptType
    {
        Invalid = -1,
        Type_Delete,
        Type_Add,
        Type_Exchange,
    }

    public enum EGuildBossState
    {
        Ready = 1,
        Battle,
        Fail,
    }

    public enum EGuildBattleState
    {
        Invalid = -1,
        First = 0,
        ReadyBegin = 1,
        OneRound = 2,
        OneRoundEnd = 3,
        TwoRound = 4,
        TwoRoundEnd = 5,
        NotBegin = 6,
        Close = 7,
    }

    public enum EGuildLuckyPacketType
    {
        System = 1,
        Vip = 2,
        GuildDinner = 3,
        Global = 4,
    }

    public enum EGuildLuckyPacketState
    {
        Sending = 1, // 可领取
        Ready = 2, // 未发送
        Over = 3, // 已结束
    }

    public enum EGuildLuckyPacketOp
    {
        Check = 1,
        Send = 2,
        Open = 3,
    }
    public enum EGuildHornType
    {
        ESuccess =1,
        ENoMoney = 2,
    }
}
