﻿/**
 * @file CharacterProperty.cs
 * @brief 角色属性类
 *          用于技能系统中的属性变化
 *
 * @author lixiaojiang
 * @version 0
 * @date 2012-11-14
 */

using System;
using System.Collections.Generic;

namespace Shark
{
  /**
   * @brief 角色属性类
   */
  public sealed class CharacterProperty
  {
    /**
     * @brief 构造函数
     *
     * @param owner
     *
     * @return 
     */
    public CharacterProperty()
    {}

    /**
     * @brief 移动速度
     */
    public float MoveSpeed
    {
      get { return m_MoveSpeed; }
    }
    /**
     * @brief 行走速度
     */
    public float WalkSpeed  //not used
    {
      get { return 0; }
    }
    /**
     * @brief 跑路速度
     */
    public float RunSpeed   //not used
    {
      get { return 0; }
    }
    /**
     * @brief 最大血量
     */
    public int HpMax
    {
      get { return m_nHpMax;}
    }

    /**
     * @brief 最大血量
     */
    public int RageMax
    {
      get { return m_RageMax; }
    }

    /**
     * @brief 最大能量
     */
    public int EnergyMax
    {
      get { return m_EnergyMax;}
    }
    public int Vampire
    {
        get { return m_Vampire; }
    }
    /**
     * @brief 生命值回复速度
     */
    public int HpRecover
    {
      get { return m_HpRecover;}
    }

    /**
     * @brief 能量值回复速度
     */
    public int EnergyRecover
    {
      get { return m_EnergyRecover;}
    }

    /**
     * @brief 基础攻击力
     */
    public int AttackBase
    {
      get { return m_nAttack;}
    }

    /**
     * @brief 基础防御力
     */
    public int ADefenceBase
    {
      get { return m_nDefence;}
    }

    /**
     * @brief 暴击率
     */
    public int Critical
    {
      get { return m_nCriticalHit; }
    }
    public int AntiCriticalHit
    {
        get { return m_nAntiCriticalHit; }
    }
    public int Block
    {
        get { return m_nBlock; }
    }
    public int AntiBlock
    {
        get { return m_nAntiBlock; }
    }
    public int AdeptElementType
    {
        get { return m_nAdeptElementType; }
    }
    public float AdeptElementFactor
    {
        get { return m_fAdeptElementFactor; }
    }
    /**
     * @brief 火伤害
     */
    public int FireDamage
    {
      get { return m_FireDam; }
    }

    /**
     * @brief 火抗性
     */
    public int FireERD
    {
      get { return m_FireERD; }
    }

    /**
     * @brief 水伤害
     */
    public int WaterDamage
    {
      get { return m_WaterDam; }
    }

    /**
     * @brief 水抗性
     */
    public int WaterERD
    {
      get { return m_WaterERD; }
    }

    /**
     * @brief 毒伤害
     */
    public int PoisonDamage
    {
      get { return m_PoisionDam; }
    }

    /**
     * @brief 毒抗性
     */
    public int PoisonERD
    {
      get { return m_PoisionERD; }
    }

    public int WindDamage
    {
        get { return m_WindDam; }
    }
    public int WindERD
    {
        get { return m_WindERD; }
    }
    public int AttackPercent
    {
        get { return m_nAttackPercent; }
    }

    public int DefencePercent
    {
        get { return m_nDefencePercent; }
    }

    public int DamageReduction
    {
        get { return m_nDamageReduction; }
    }

    public int MaNaS
    {
        get { return m_nMaNaS; }
    }

    public int AngryS
    {
        get { return m_nAngryS; }
    }

    public int DropS
    {
        get { return m_nDropS; }
    }

    public int SuspendedInvicibleS
    {
        get { return m_nSuspendedInvicibleS; }
    }
    public float AttackRange
    {
      get { return m_AttackRange; }
    }

    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetMoveSpeed(Operate_Type opType, float tVal)
    {
      m_MoveSpeed = UpdateAttr(m_MoveSpeed, m_MoveSpeed, opType, tVal);
    }
    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetWalkSpeed(Operate_Type opType, float tVal)
    {
      //m_WalkSpeed = UpdateAttr(m_WalkSpeed, m_WalkSpeed, opType, tVal);
    }
    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetRunSpeed(Operate_Type opType, float tVal)
    {
      //m_RunSpeed = UpdateAttr(m_RunSpeed, m_RunSpeed, opType, tVal);
    }
    
    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetHpMax(Operate_Type opType, int tVal)
    {
      m_nHpMax = (int)UpdateAttr(m_nHpMax, m_nHpMax, opType, tVal);
    }

    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetRageMax(Operate_Type opType, int tVal)
    {
      m_RageMax = (int)UpdateAttr(m_RageMax, m_RageMax, opType, tVal);
    }

    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetEnergyMax(Operate_Type opType, int tVal)
    {
      m_EnergyMax = (int)UpdateAttr(m_EnergyMax, m_EnergyMax, opType, tVal);
    }

    public void SetVampire(Operate_Type opType, int tVal)
    {
        m_Vampire = (int)UpdateAttr(m_Vampire, opType, tVal);
    }
    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetHpRecover(Operate_Type opType, float tVal)
    {
        m_HpRecover = (int)UpdateAttr(m_HpRecover, opType, tVal);
    }
    
    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetEnergyRecover(Operate_Type opType, float tVal)
    {
      m_EnergyRecover = (int)UpdateAttr(m_EnergyRecover, opType, tVal);
    }
    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetAttackBase(Operate_Type opType, int tVal)
    {
      m_nAttack = (int)UpdateAttr(m_nAttack, opType, tVal);
    }

    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetADefenceBase(Operate_Type opType, int tVal)
    {
      m_nDefence = (int)UpdateAttr(m_nDefence, opType, tVal);
    }
        
    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetCritical(Operate_Type opType, float tVal)
    {
      m_nCriticalHit = (int)UpdateAttr(m_nCriticalHit, opType, tVal);
    }
    public void SetAntiCriticalHit(Operate_Type opType, float tVal)
    {
        m_nAntiCriticalHit = (int)UpdateAttr(m_nAntiCriticalHit, opType, tVal);
    }
    public void SetBlock(Operate_Type opType, float tVal)
    {
        m_nBlock = (int)UpdateAttr(m_nBlock, opType, tVal);
    }

    public void SetAntiBlock(Operate_Type opType, float tVal)
    {
        m_nAntiBlock = (int)UpdateAttr(m_nAntiBlock, opType, tVal);
    }
    public void SetAdeptElementType(Operate_Type opType, int nType)
    {
        m_nAdeptElementType = nType;
    }
    public void SetAdeptElementFactor(Operate_Type opType, float tVal)
    {
        m_fAdeptElementFactor = (int)UpdateAttr(m_fAdeptElementFactor, opType, tVal);
    }
    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetFireDamage(Operate_Type opType, float tVal)
    {
        m_FireDam = (int)UpdateAttr(m_FireDam, opType, tVal);
    }

    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetFireERD(Operate_Type opType, float tVal)
    {
        m_FireERD = (int)UpdateAttr(m_FireERD, opType, tVal);
    }

    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetWaterDamage(Operate_Type opType, float tVal)
    {
        m_WaterDam = (int)UpdateAttr(m_WaterDam, opType, tVal);
    }

    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetWaterERD(Operate_Type opType, float tVal)
    {
        m_WaterERD = (int)UpdateAttr(m_WaterERD, opType, tVal);
    }

    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetWindDamage(Operate_Type opType, float tVal)
    {
        m_WindDam = (int)UpdateAttr(m_WindDam, opType, tVal);
    }
    public void SetWindERD(Operate_Type opType, float tVal)
    {
        m_WindERD = (int)UpdateAttr(m_WindERD, opType, tVal);
    }
    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetPoisionDamage(Operate_Type opType, float tVal)
    {
        m_PoisionDam = (int)UpdateAttr(m_PoisionDam, opType, tVal);
    }
    public void SetPoisionERD(Operate_Type opType, float tVal)
    {
        m_PoisionERD = (int)UpdateAttr(m_PoisionERD, opType, tVal);
    }
    public void SetAttackPercent(Operate_Type opType, float tVal)
    {
        m_nAttackPercent = (int)UpdateAttr(m_nAttackPercent, opType, tVal);
    }
    public void SetDefencePercent(Operate_Type opType, float tVal)
    {
        m_nDefencePercent = (int)UpdateAttr(m_nDefencePercent, opType, tVal);
    }
    public void SetDamageReduction(Operate_Type opType, float tVal)
    {
        m_nDamageReduction = (int)UpdateAttr(m_nDamageReduction, opType, tVal);
    }
    public void SetMaNaS(Operate_Type opType, float tVal)
    {
        m_nMaNaS = (int)UpdateAttr(m_nMaNaS, opType, tVal);
    }
    public void SetAngryS(Operate_Type opType, float tVal)
    {
        m_nAngryS = (int)UpdateAttr(m_nAngryS, opType, tVal);
    }
    public void SetDropS(Operate_Type opType, float tVal)
    {
        m_nDropS = (int)UpdateAttr(m_nDropS, opType, tVal);
    }
    public void SetSuspendedInvicibleS(Operate_Type opType, float tVal)
    {
        m_nSuspendedInvicibleS = (int)UpdateAttr(m_nSuspendedInvicibleS, opType, tVal);
    }

    /**
     * @brief 角色属性修改
     *
     * @param optype 操作类型
     * @param val 值
     *
     */
    public void SetAttackRange(Operate_Type opType, float tVal)
    {
      m_AttackRange = UpdateAttr(m_AttackRange, opType, tVal);
    }

    public static float UpdateAttr(float val, float maxVal, Operate_Type opType, float tVal)
    {
      float ret = val;
      if (opType == Operate_Type.OT_PercentMax) {       
        float t = maxVal * (tVal/100.0f);
        ret = t;
      } else {
        ret = UpdateAttr(val, opType, tVal);
      }
      return ret;
    }

    public static float UpdateAttr(float val, Operate_Type opType, float tVal)
    {
      float ret = val;
      if (opType == Operate_Type.OT_Absolute) {
        ret = tVal;
      } else if (opType == Operate_Type.OT_Relative) {
        float t = (ret + tVal);
        if (t < 0) {
          t = 0;
        }
        ret = t;
      } else if (opType == Operate_Type.OT_PercentCurrent) {
        float t = (ret * (tVal / 100.0f));
        ret = t;
      }
      return ret;
    }

    /**
     * @brief 最大生命值
     */
    private int m_nHpMax;
    /**
        * @brief 基础攻击力
        */
    private int m_nAttack;
    /**
     * @brief 物理防御力
     */
    private int m_nDefence;
    /**
     * @brief 最大能量值
     */
    private int m_EnergyMax;
    /**
     * @brief 吸血
     */
    private int m_Vampire;
    /**
     * @brief 暴击率
     */
    private int m_nCriticalHit;
    /**
     * @brief 抗暴击率
     */
    private int m_nAntiCriticalHit;
    /**
     * @brief 格挡率
     */
    private int m_nBlock;
    /**
     * @brief 抗格挡
     */
    private int m_nAntiBlock;
    /**
     * @brief 属性倾向
     */
    private int m_nAdeptElementType;
    /**
     * @brief 属性倾向系数
     */
    private float m_fAdeptElementFactor;
    /**
     * @brief 火伤害
     */
    private int m_FireDam;
    /**
     * @brief 火抗性
     */
    private int m_FireERD;
    /**
     * @brief 水伤害
     */
    private int m_WaterDam;
    /**
     * @brief 水抗性
     */
    private int m_WaterERD;
    /**
     * @brief 土伤害
     */
    private int m_PoisionDam;
    /**
     * @brief 土抗性
     */
    private int m_PoisionERD;
    /**
     * @brief 风伤害
     */
    private int m_WindDam;
    /**
     * @brief 攻击百分比加成
     */
    private int m_nAttackPercent;
    /**
     * @brief 防御百分比加成
     */
    private int m_nDefencePercent;
    /**
     * @brief 伤害减免百分比
     */
    private int m_nDamageReduction;
    /**
     * @brief 风抗性
     */
    private int m_WindERD;
    /**
     * @brief 最大怒气值
     */
    private int m_RageMax;
    /**
     * @brief 心领神会
     */
    private int m_nMaNaS;
    /**
     * @brief 怒发冲冠
     */
    private int m_nAngryS;
    /**
     * @brief 乾坤一掷
     */
    private int m_nDropS;
    /**
     * @brief 浮空无敌
     */
    private int m_nSuspendedInvicibleS;

    /**
     * @brief 生命值回复速度
     */
    private int m_HpRecover;
    /**
     * @brief 能量值回复速度
     */
    private int m_EnergyRecover;
    /**
     * @brief 奔跑速度
     */
    private float m_MoveSpeed;   
    /**
     * @brief 攻击距离
     */
    private float m_AttackRange;
  }
}
