﻿using System.Collections.Generic;

namespace Shark
{
    public partial class DataProvider
    {
        private void InitMultiLanguage()
        {
            LoadData(Tab_tempLangInfoProvider.Instance, "langInfo.txt");
            Tab_LangInfoProvider.Instance.Init();
        }
    }

    public enum LANGUAGE
    {
        NONE = -1,
        /// <summary>
        /// 简体中文
        /// </summary>
        CHINESE = 0,
        /// <summary>
        /// 繁体中文
        /// </summary>
        TCHINESE,
        /// <summary>
        /// 英文
        /// </summary>
        ENGLISH,
        /// <summary>
        /// 韩文
        /// </summary>
        KOREA,
        /// <summary>
        /// 泰文
        /// </summary>
        THAILAND,
        /// <summary>
        /// 越南文
        /// </summary>
        VIETNAM,
        MAX,
    }

    public class Tab_LangInfo : IDataUnit
    {
        private static int langInfoID = 0;
        public string[] langInfo = new string[(int)LANGUAGE.MAX];

        public void Load(string dataRow)
        {
            langInfoID++;
            string[] cols = dataRow.Split('\t');
            for (int i = 0; i < cols.Length; i++)
            {
                langInfo[i] = cols[i];
            }
        }
        public int GetId()
        {
            return langInfoID;
        }
    }

    public class Tab_tempLangInfoProvider : DataInstance<Tab_LangInfo> { }

    public class Tab_LangInfoProvider
    {
        private static readonly int defaultLang = (int)LANGUAGE.CHINESE;    //需要修改的默认语种,现在设置为中文
        public static Tab_LangInfoProvider Instance = new Tab_LangInfoProvider();
        public Dictionary<string, Tab_LangInfo> mData = new Dictionary<string, Tab_LangInfo>();

        //直接获取多语言文字,使用频率较低,偷懒的时候不知道文字来源的时候使用
        public string GetLangString(string str, LANGUAGE language = LANGUAGE.ENGLISH)
        {
            if (language > LANGUAGE.NONE && language < LANGUAGE.MAX && mData.ContainsKey(str))
            {
                Tab_LangInfo tab_LangInfo = mData[str];
                string langStr = tab_LangInfo.langInfo[((int)language)];
                if (!string.IsNullOrEmpty(langStr))
                {
                    return langStr;
                }
            }
            return str;
        }

        public void Init()
        {
            mData.Clear();
            foreach (var tab in Tab_tempLangInfoProvider.Instance.GetData().Values)
            {
                if (!mData.ContainsKey(tab.langInfo[defaultLang]))
                {
                    mData.Add(tab.langInfo[defaultLang], tab);
                }
            }
            //在这里添加需要多语种支持的文件start
            Tab_AchievementBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_AdvancedBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_ArtifactBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_BenYuanItemBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_ChatLimitProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_CommonItemProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_CopySceneLimitProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_DestinyBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_DestinyBloodBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_GodWeaponBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_HunJiangItemBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_HunJiangJiBanBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_JieYuanBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_JieYuanSuitInfoProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_LadderProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_LingBaoBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_MarryTitleBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_OldGodDiamondBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_OldGodItemBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_OldGodUnitBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_PassiveSkillBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_PlayerSkinBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_RankBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_RMBProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_RoleBaseAttrProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_SceneClassProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_ShenShouBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_ShenShouEquipBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_ShenWangZhanJiaEquipProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_ShenYuFengHaoBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_ShenZhiJingBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_StarCraftMapProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_StarmapBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_StarSoulUnitBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_WarPetEquipProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_WingBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_WingTransmogProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            Tab_XingHunItemBaseProvider.Instance.ListData.ForEach(i => i.SetName(i.Name));
            //在这里添加需要多语种支持的文件end
            Tab_XingYunGuideEventProvider.Instance.ListData.ForEach(i => i.SetName(i.ExtraDropItemName));
            Tab_MailProvider.Instance.ListData.ForEach(i => i.SetMail(i.Title, i.Content));
        }
    }

    public class MultiName
    {
        public string defaultName = null;
        public string[] langName = null;

        public void SetName(string name)
        {
            defaultName = name;
            if (langName == null)
            {
                langName = new string[(int)LANGUAGE.MAX];
            }
            Tab_LangInfo tab_LangInfo;
            if (Tab_LangInfoProvider.Instance.mData.TryGetValue(defaultName, out tab_LangInfo))
            {
                for (int i = 0; i < tab_LangInfo.langInfo.Length; i++)
                {
                    AddName(i, tab_LangInfo.langInfo[i]);
                }
            }
        }

        public string GetName(LANGUAGE lang = LANGUAGE.ENGLISH)
        {
            if (langName != null)
            {
                if (lang >= LANGUAGE.CHINESE && lang < LANGUAGE.MAX)
                {
                    string str = langName[(int)lang];
                    if (!string.IsNullOrEmpty(str))
                    {
                        return str;
                    }
                }
                return defaultName;
            }
            return "";
        }

        private void AddName(int lang, string name)
        {
            if (lang >= 0 && lang < (int)LANGUAGE.MAX)
            {
                langName[lang] = name;
            }
        }
    }

    public class MultiMail
    {
        public string defaultTitle = null;
        public string[] langTitle = null;
        public string defaultContent = null;
        public string[] langContent = null;

        public void SetMail(string title, string content)
        {
            defaultTitle = title;
            defaultContent = content;
            if (langTitle == null)
            {
                langTitle = new string[(int)LANGUAGE.MAX];
                langContent = new string[(int)LANGUAGE.MAX];
            }
            Tab_LangInfo tab_LangInfoTitle;
            if (Tab_LangInfoProvider.Instance.mData.TryGetValue(defaultTitle, out tab_LangInfoTitle))
            {
                for (int i = 0; i < tab_LangInfoTitle.langInfo.Length; i++)
                {
                    AddTitle(i, tab_LangInfoTitle.langInfo[i]);
                }
            }
            Tab_LangInfo tab_LangInfoContent;
            if (Tab_LangInfoProvider.Instance.mData.TryGetValue(defaultContent, out tab_LangInfoContent))
            {
                for (int i = 0; i < tab_LangInfoContent.langInfo.Length; i++)
                {
                    AddContent(i, tab_LangInfoContent.langInfo[i]);
                }
            }
        }

        public string GetTitle(LANGUAGE lang)
        {
            if (langTitle != null)
            {
                if (lang >= LANGUAGE.CHINESE && lang < LANGUAGE.MAX)
                {
                    string str = langTitle[(int)lang];
                    if (!string.IsNullOrEmpty(str))
                    {
                        return str;
                    }
                }
                return defaultTitle;
            }
            return "";
        }

        public string GetContent(LANGUAGE lang)
        {
            if (langContent != null)
            {
                if (lang >= LANGUAGE.CHINESE && lang < LANGUAGE.MAX)
                {
                    string str = langContent[(int)lang];
                    if (!string.IsNullOrEmpty(str))
                    {
                        return str;
                    }
                }
                return defaultContent;
            }
            return "";
        }

        private void AddTitle(int lang, string name)
        {
            if (lang >= 0 && lang < (int)LANGUAGE.MAX)
            {
                langTitle[lang] = name;
            }
        }

        private void AddContent(int lang, string name)
        {
            if (lang >= 0 && lang < (int)LANGUAGE.MAX)
            {
                langContent[lang] = name;
            }
        }
    }

    //在这里添加需要多语种支持的文件的partial类
    public partial class Tab_AchievementBase : MultiName { }
    public partial class Tab_AdvancedBase : MultiName { }
    public partial class Tab_ArtifactBase : MultiName { }
    public partial class Tab_BenYuanItemBase : MultiName { }
    public partial class Tab_ChatLimit : MultiName { }
    public partial class Tab_CommonItem : MultiName { }
    public partial class Tab_CopySceneLimit : MultiName { }
    public partial class Tab_DestinyBase : MultiName { }
    public partial class Tab_DestinyBloodBase : MultiName { }
    public partial class Tab_GodWeaponBase : MultiName { }
    public partial class Tab_HunJiangItemBase : MultiName { }
    public partial class Tab_HunJiangJiBanBase : MultiName { }
    public partial class Tab_JieYuanBase : MultiName { }
    public partial class Tab_JieYuanSuitInfo : MultiName { }
    public partial class Tab_Ladder : MultiName { }
    public partial class Tab_LingBaoBase : MultiName { }
    public partial class Tab_MarryTitleBase : MultiName { }
    public partial class Tab_OldGodDiamondBase : MultiName { }
    public partial class Tab_OldGodItemBase : MultiName { }
    public partial class Tab_OldGodUnitBase : MultiName { }
    public partial class Tab_PassiveSkillBase : MultiName { }
    public partial class Tab_PlayerSkinBase : MultiName { }
    public partial class Tab_RankBase : MultiName { }
    public partial class Tab_RMB : MultiName { }
    public partial class Tab_RoleBaseAttr : MultiName { }
    public partial class Tab_SceneClass : MultiName { }
    public partial class Tab_ShenShouBase : MultiName { }
    public partial class Tab_ShenShouEquipBase : MultiName { }
    public partial class Tab_ShenWangZhanJiaEquip : MultiName { }
    public partial class Tab_ShenYuFengHaoBase : MultiName { }
    public partial class Tab_ShenZhiJingBase : MultiName { }
    public partial class Tab_StarCraftMap : MultiName { }
    public partial class Tab_StarmapBase : MultiName { }
    public partial class Tab_StarSoulUnitBase : MultiName { }
    public partial class Tab_WarPetEquip : MultiName { }
    public partial class Tab_WingBase : MultiName { }
    public partial class Tab_WingTransmog : MultiName { }
    public partial class Tab_XingHunItemBase : MultiName { }
    public partial class Tab_XingYunGuideEvent : MultiName { }

    //邮件系统单独处理
    public partial class Tab_Mail : MultiMail { }
}
