﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace Shark
{
    public delegate byte[] delegate_ReadFile(string path);
    public delegate bool delegate_ExistFile(string path);

    public static class FileReaderProxy
    {
        private static delegate_ReadFile handlerReadFile;
        private static delegate_ExistFile handlerExistFile;

        public static MemoryStream ReadFileAsMemoryStream(string filePath)
        {
            try
            {
                byte[] buffer = ReadFileAsArray(filePath);
                if (buffer == null)
                {
                    LogSystem.Error("Err ReadFileAsMemoryStream failed:{0}\n", filePath);
                    return null;
                }
                return new MemoryStream(buffer);
            }
            catch (Exception e)
            {
                LogSystem.Error("Exception:{0}\n", e.Message);
                Helper.LogCallStack();
                return null;
            }
        }

        public static byte[] ReadFileAsArray(string filePath)
        {
            byte[] buffer = null;
            try
            {
                if (handlerReadFile != null)
                {
                    buffer = handlerReadFile(filePath);
                }
                else {
                    LogSystem.Error("ReadFileByEngine handler have not register: {0}", filePath);
                }
            }
            catch (Exception e)
            {
                LogSystem.Error("Exception:{0}\n", e.Message);
                Helper.LogCallStack();
                return null;
            }
            return buffer;
        }

        public static bool Exists(string filePath)
        {
            if (handlerExistFile != null)
                return handlerExistFile(filePath);
            return File.Exists(filePath);
        }

        public static void RegisterReadFileHandler(delegate_ReadFile handler)
        {
            handlerReadFile = handler;
        }
        public static void RegisterExistFileHandler(delegate_ExistFile handler)
        {
            handlerExistFile = handler;
        }

    }
}
