﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Security.Permissions;
using System.Threading;
using UnityEngine;
namespace Shark
{
    public interface IDataUnit
    {
        void Load(string dataRow);
        int GetId();
    }
    public class DataInstance<T> where T : IDataUnit, new()
    {
        public static DataInstance<T> Instance = new DataInstance<T>();
        private Dictionary<int, T> mData = new Dictionary<int, T>();
        public List<T> ListData = new List<T>();
        public void Load(string dataTable)
        {
            if(DataProvider.Instance.IsOnlineLoad)
            {
                Dictionary<int, T> mTmp = new Dictionary<int, T>();
                Load(dataTable,mTmp);
                mData = mTmp;
            }
            else
            {
                mData.Clear();
                Load(dataTable, mData);
            }
            ListData.Clear();
            //Dictionary<int, T>.ValueCollection Lst = mData.Values;
            //ListData.AddRange(Lst);
            foreach (var kv in mData)
            {
                ListData.Add(kv.Value);
            }
        }
        static Stopwatch dog = new Stopwatch();
        static long tickSpan = TimeSpan.TicksPerSecond / 15;
        bool CheckAndSleep()
        {
            if (dog.ElapsedTicks > tickSpan)
            {
                Thread.Sleep(10);
                dog.Reset();
                return true;
            }
            return false;
        }
        public void Load(string dataTable,Dictionary<int,T> dicContainer)
        {
            string[] rows = dataTable.Split('\n');
            int len = rows.Length;
            int nCurId = -1;
            for (int i = 0; i < len; i++)
            {
                if (DataProvider.UseThreadleep)
                {
                    CheckAndSleep();
                }
                if (rows[i].StartsWith("#")||rows[i].Equals(""))
                {
                    continue;
                }

                T unit = new T();
                unit.Load(rows[i]);
                int id = unit.GetId();
                if (id != -1)
                {
                    dicContainer.Add(id, unit);
                }
            }
        }
        public T GetDataById(int id)
        {
            if (null != DataProvider.OnCollectDataType)
            {
                DataProvider.OnCollectDataType(this.GetType());
            }
            if (mData.ContainsKey(id))
                return mData[id];

            if (null != DataProvider.OnInvaildDataEvent) {
                DataProvider.OnInvaildDataEvent(this.GetType(), id, mData.Count);
            }
            return default(T);
        }
        public Dictionary<int, T> GetData()
        {
            if (null != DataProvider.OnCollectDataType)
            {
                DataProvider.OnCollectDataType(this.GetType());
            }
            return mData;
        }
    }
    
    /// <summary>
    /// 负责从文本读取数据，新建MyDataTable
    /// </summary>
    public partial class DataProvider
    {
        /// <summary>
        /// 处理表中不存在的数据
        /// </summary>
        public static Action<Type, int, int> OnInvaildDataEvent;
        public static Action<Type> OnCollectDataType;
        public delegate string ReadAllTextDelegate(string relative_path);
        public delegate void ReadFinishDelegate();
        public delegate void LogDelegate(string format, params object[] p);
        public bool IsOnlineLoad = false;
        public bool HasLoadServerListConfig = false;
        private ReadAllTextDelegate readAllTextHandler = null;
        private ReadFinishDelegate readFinishDelegate = null;
        public LogDelegate logHandler = null;
        private static DataProvider _Instance = new DataProvider();
		public static bool IsDelayLoad = false;
        public static bool UseThreadleep = false;
        public static DataProvider Instance
        {
            get { return _Instance; }
        }
        public void Init(ReadAllTextDelegate handler, ReadFinishDelegate onFinish = null)
        {//Call By Outer
            if (handler == null)
                return;
            readAllTextHandler = handler;
            readFinishDelegate = onFinish;
            LoadAllData();
            InitMultiLanguage();
        }
        public void ClientInit(ReadAllTextDelegate handler,MonoBehaviour behav,ReadFinishDelegate onFinish)
        {//Call By Outer
            if (handler == null)
                return;
            readAllTextHandler = handler;
            readFinishDelegate = onFinish;
            behav.StartCoroutine(LoadAllClientData());
        }
        public void ClientTxtInit(ReadAllTextDelegate handler, ReadFinishDelegate onFinish)
        {//Call By Outer
            if (handler == null)
                return;
            readAllTextHandler = handler;
            readFinishDelegate = onFinish;
            LoadClientTxt();
        }
        public void PublicTxtInit(ReadAllTextDelegate handler, ReadFinishDelegate onFinish)
        {//Call By Outer
            if (handler == null)
                return;
            readAllTextHandler = handler;
            readFinishDelegate = onFinish;
            LoadPublicTxt();
        }
        public void PreGameTxtInit(ReadAllTextDelegate handler, ReadFinishDelegate onFinish)
        {//Call By Outer
            if (handler == null)
                return;
            readAllTextHandler = handler;
            readFinishDelegate = onFinish;
            LoadPreGameTxt();
        }
        public void PreGameTxt2Init(ReadAllTextDelegate handler, ReadFinishDelegate onFinish)
        {//Call By Outer
            if (handler == null)
                return;
            readAllTextHandler = handler;
            readFinishDelegate = onFinish;
            LoadPreGameTxt2();
        }
        public void PreGameTxt3Init(ReadAllTextDelegate handler, ReadFinishDelegate onFinish)
        {//Call By Outer
            if (handler == null)
                return;
            readAllTextHandler = handler;
            readFinishDelegate = onFinish;
            LoadPreGameTxt3();
        }
        private void LoadData<T>(DataInstance<T> container, string relativePath) where T : IDataUnit, new()
        {
            string data = ReadAllText(relativePath);
            if (string.IsNullOrEmpty(data))
                return;
            if (IsOnlineLoad && !HasLoadServerListConfig && relativePath == "Server/ServerConfigList.txt")
            {
                HasLoadServerListConfig = true;
                try
                {
                    container.Load(data);
                }
                catch (Exception e)
                {
                    Log("LoadData ServerConfigList Error : {0}", e.Message);
                }
            }
            //MyDataTable table = new MyDataTable(data, relativePath);
            container.Load(data);
        }
        public void Log(string format, params object[] p)
        {
            if (logHandler != null)
                logHandler(format, p);
        }
        public string ReadAllText(string relativePath)
        {
            try
            {
                if (readAllTextHandler == null)
                    return string.Empty;
                string data = readAllTextHandler(relativePath);
                if (string.IsNullOrEmpty(data))
                    return string.Empty;
                return data;
            }
            catch(Exception e)
            {
                Log("Read All Text ERROR : {0}", e.Message);
            }
            return string.Empty;
        }
    }
}
