using System;
using System.Collections.Generic;

namespace Shark
{
	public class DataParser
	{
		public static T Parse<T>(MyDataRow row, string colName, T defaultVal)
		{
			T t = defaultVal;
			T result;
			if (row == null || string.IsNullOrEmpty(colName))
			{
				result = t;
			}
			else
			{
				try
				{
					if (!string.IsNullOrEmpty(row[colName]))
					{
						t = (T)((object)System.Convert.ChangeType(row[colName], typeof(T)));
					}
				}
				catch (System.Exception ex)
				{
					DataProvider.Instance.Log("DataParser.Parse<{0}> at Table: {1}({2}, {3}), error: {4}", new object[]
					{
						typeof(T).ToString(),
						row.Table.TableName,
						row.RowId,
						colName,
						ex.Message
					});
				}
				result = t;
			}
			return result;
		}

		public static System.Collections.Generic.List<T> ParseList<T>(MyDataRow row, string prefix, T defaultVal)
		{
			System.Collections.Generic.List<T> list = new System.Collections.Generic.List<T>();
			int num = 20;
			for (int i = 0; i < num; i++)
			{
				string colName = string.Format("{0}{1}", prefix, i);
				int headerIndexByColName = row.Table.GetHeaderIndexByColName(colName);
				if (headerIndexByColName < 0)
				{
					break;
				}
				list.Add(DataParser.Parse<T>(row, colName, defaultVal));
			}
			return list;
		}

		public static T Parse<T>(MyDataRow row, int col, T defaultVal)
		{
			T t = defaultVal;
			T result;
			if (row == null || col > row.ColNum - 1)
			{
				result = t;
			}
			else
			{
				try
				{
					if (!string.IsNullOrEmpty(row[col]))
					{
						t = (T)((object)System.Convert.ChangeType(row[col], typeof(T)));
					}
				}
				catch (System.Exception ex)
				{
					DataProvider.Instance.Log("DataParser.Parse<{0}> at Table: {1}({2}, {3}), error: {4}", new object[]
					{
						typeof(T).ToString(),
						row.Table.TableName,
						row.RowId,
						col,
						ex.Message
					});
				}
				result = t;
			}
			return result;
		}

        public static int Parseint(MyDataRow row, string colName, int defaultVal)
        {
            int t = defaultVal;
            int result;
            if (row == null || string.IsNullOrEmpty(colName))
            {
                result = t;
            }
            else
            {
                try
                {
                    if (!string.IsNullOrEmpty(row[colName]))
                    {
                        t = Convert.ToInt32(row[colName]);
                    }
                }
                catch (System.Exception ex)
                {
                    DataProvider.Instance.Log("DataParser.Parse<int> at Table: {0}({1}, {2}), error: {3}", new object[]
                    {
                        row.Table.TableName,
                        row.RowId,
                        colName,
                        ex.Message
                    });
                }
                result = t;
            }
            return result;
        }
        public static bool Parsebool(MyDataRow row, string colName, bool defaultVal)
        {
            bool t = defaultVal;
            bool result;
            if (row == null || string.IsNullOrEmpty(colName))
            {
                result = t;
            }
            else
            {
                try
                {
                    if (!string.IsNullOrEmpty(row[colName]))
                    {
                        t = row[colName].Equals("TRUE")?true:false;
                    }
                }
                catch (System.Exception ex)
                {
                    DataProvider.Instance.Log("DataParser.Parse<bool> at Table: {0}({1}, {2}), error: {3}", new object[]
                    {
                        row.Table.TableName,
                        row.RowId,
                        colName,
                        ex.Message
                    });
                }
                result = t;
            }
            return result;
        }
        public static string Parsestring(MyDataRow row, string colName, string defaultVal)
        {
            string t = defaultVal;
            string result;
            if (row == null || string.IsNullOrEmpty(colName))
            {
                result = t;
            }
            else
            {
                try
                {
                        t = row[colName];
                }
                catch (System.Exception ex)
                {
                    DataProvider.Instance.Log("DataParser.Parse<string> at Table: {0}({1}, {2}), error: {3}", new object[]
                    {
                        row.Table.TableName,
                        row.RowId,
                        colName,
                        ex.Message
                    });
                }
                result = t;
            }
            return result;
        }
        public static float Parsefloat(MyDataRow row, string colName, float defaultVal)
        {
            float t = defaultVal;
            float result;
            if (row == null || string.IsNullOrEmpty(colName))
            {
                result = t;
            }
            else
            {
                try
                {
                    if (!string.IsNullOrEmpty(row[colName]))
                    {
                        t = (float)Convert.ToDouble(row[colName]);                        
                    }
                }
                catch (System.Exception ex)
                {
                    DataProvider.Instance.Log("DataParser.Parse<{0}> at Table: {1}({2}, {3}), error: {4}", new object[]
                    {
                        typeof(float).ToString(),
                        row.Table.TableName,
                        row.RowId,
                        colName,
                        ex.Message
                    });
                }
                result = t;
            }
            return result;
        }
        public static System.Collections.Generic.List<int> ParseListint(MyDataRow row, string prefix, int defaultVal)
        {
            System.Collections.Generic.List<int> list = new System.Collections.Generic.List<int>();
            int num = 20;
            for (int i = 0; i < num; i++)
            {
                string colName = string.Format("{0}{1}", prefix, i);
                int headerIndexByColName = row.Table.GetHeaderIndexByColName(colName);
                if (headerIndexByColName < 0)
                {
                    break;
                }
                list.Add(DataParser.Parseint(row, colName, defaultVal));
            }
            return list;
        }
        public static System.Collections.Generic.List<bool> ParseListbool(MyDataRow row, string prefix, bool defaultVal)
        {
            System.Collections.Generic.List<bool> list = new System.Collections.Generic.List<bool>();
            int num = 20;
            for (int i = 0; i < num; i++)
            {
                string colName = string.Format("{0}{1}", prefix, i);
                int headerIndexByColName = row.Table.GetHeaderIndexByColName(colName);
                if (headerIndexByColName < 0)
                {
                    break;
                }
                list.Add(DataParser.Parsebool(row, colName, defaultVal));
            }
            return list;
        }
        public static System.Collections.Generic.List<string> ParseListstring(MyDataRow row, string prefix, string defaultVal)
        {
            System.Collections.Generic.List<string> list = new System.Collections.Generic.List<string>();
            int num = 20;
            for (int i = 0; i < num; i++)
            {
                string colName = string.Format("{0}{1}", prefix, i);
                int headerIndexByColName = row.Table.GetHeaderIndexByColName(colName);
                if (headerIndexByColName < 0)
                {
                    break;
                }
                list.Add(DataParser.Parsestring(row, colName, defaultVal));
            }
            return list;
        }
        public static System.Collections.Generic.List<float> ParseListfloat(MyDataRow row, string prefix, float defaultVal)
        {
            System.Collections.Generic.List<float> list = new System.Collections.Generic.List<float>();
            int num = 20;
            for (int i = 0; i < num; i++)
            {
                string colName = string.Format("{0}{1}", prefix, i);
                int headerIndexByColName = row.Table.GetHeaderIndexByColName(colName);
                if (headerIndexByColName < 0)
                {
                    break;
                }
                list.Add(DataParser.Parsefloat(row, colName, defaultVal));
            }
            return list;
        }
        public static int Parseint(MyDataRow row, int col, int defaultVal)
        {
            int t = defaultVal;
            int result;
            if (row == null || col > row.ColNum - 1)
            {
                result = t;
            }
            else
            {
                try
                {
                    if (!string.IsNullOrEmpty(row[col]))
                    {
                        t = Convert.ToInt32(row[col]);                       
                    }
                }
                catch (System.Exception ex)
                {
                    DataProvider.Instance.Log("DataParser.Parse<{0}> at Table: {1}({2}, {3}), error: {4}", new object[]
                    {
                        typeof(int).ToString(),
                        row.Table.TableName,
                        row.RowId,
                        col,
                        ex.Message
                    });
                }
                result = t;
            }
            return result;
        }
        public static bool Parsebool(MyDataRow row, int col, bool defaultVal)
        {
            bool t = defaultVal;
            bool result;
            if (row == null || col > row.ColNum - 1)
            {
                result = t;
            }
            else
            {
                try
                {
                    if (!string.IsNullOrEmpty(row[col]))
                    {
                        t = row[col].Equals("TRUE") ?true:false;
                    }
                }
                catch (System.Exception ex)
                {
                    DataProvider.Instance.Log("DataParser.Parse<{0}> at Table: {1}({2}, {3}), error: {4}", new object[]
                    {
                        typeof(bool).ToString(),
                        row.Table.TableName,
                        row.RowId,
                        col,
                        ex.Message
                    });
                }
                result = t;
            }
            return result;
        }
        public static string Parsestring(MyDataRow row, int col, string defaultVal)
        {
            string t = defaultVal;
            string result;
            if (row == null || col > row.ColNum - 1)
            {
                result = t;
            }
            else
            {
                try
                {
                    t = row[col];
                }
                catch (System.Exception ex)
                {
                    DataProvider.Instance.Log("DataParser.Parse<{0}> at Table: {1}({2}, {3}), error: {4}", new object[]
                    {
                        typeof(string).ToString(),
                        row.Table.TableName,
                        row.RowId,
                        col,
                        ex.Message
                    });
                }
                result = t;
            }
            return result;
        }
        public static float Parsefloat(MyDataRow row, int col, float defaultVal)
        {
            float t = defaultVal;
            float result;
            if (row == null || col > row.ColNum - 1)
            {
                result = t;
            }
            else
            {
                try
                {
                    if (!string.IsNullOrEmpty(row[col]))
                    {
                        t = (float)Convert.ToDouble(row[col]);
                    }
                }
                catch (System.Exception ex)
                {
                    DataProvider.Instance.Log("DataParser.Parse<{0}> at Table: {1}({2}, {3}), error: {4}", new object[]
                    {
                        typeof(float).ToString(),
                        row.Table.TableName,
                        row.RowId,
                        col,
                        ex.Message
                    });
                }
                result = t;
            }
            return result;
        }
    }
}
